;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: modulename -*-
#|
-----------------------------------------------------------------------------------
TITLE: a very short characterisation of the content
-----------------------------------------------------------------------------------
File:    defstandardclass.lisp
Version: 1.7 (last modification on Tue Oct 12 11:11:53 1993)
State:   proposed

DESCRIPTION:
the description of the content

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
i.mohr

CONTACT: 
i.mohr

HISTORY: 
Log for /export/home/saturn/hfried/Lisp/Apply/defstandardclass.lisp[1.0]
	Fri Mar  5 15:45:16 1993 imohr@isst save $
 defining form for default class definitions
 
defstandardclass.lisp[1.1] Thu Mar 18 11:57:15 1993 ukriegel@isst save $
 [Thu Mar 18 11:55:31 1993] Intention for change:
 replace RCS-HEADER with shape-header
 done, im. has to fill out comment slots
 
defstandardclass.lisp[1.2] Thu Mar 18 15:15:38 1993 imohr@isst proposed $
 [Thu Mar 18 15:13:41 1993] Intention for change:
 The saved version was an old one.
 It's now o.k.
 
defstandardclass.lisp[1.3] Thu Mar 18 15:40:03 1993 imohr@isst proposed $
 [Thu Mar 18 15:38:51 1993] Intention for change:
 bug eliminated in make-eulisp-class-id
 
defstandardclass.lisp[1.4] Tue Jun 15 15:08:49 1993 imohr@isst save $
 [Tue Jun 15 13:59:05 1993] Intention for change:
 compiling EL-modules
 
defstandardclass.lisp[1.5] Thu Jun 17 09:00:13 1993 imohr@isst proposed $
 [Wed Jun 16 12:29:38 1993] Intention for change:
 defconstant -> setq
 compilation ok
 
defstandardclass.lisp[1.6] Tue Aug 31 15:15:57 1993 ukriegel@isst published $
 [Tue Aug 31 14:53:35 1993] Intention for change:
 :cmu
 :cmu is cltl1 -> in-package with '
 
defstandardclass.lisp[1.7] Tue Oct 12 13:05:36 1993 imohr@isst proposed $
 [Tue Oct 12 11:09:27 1993] Intention for change:
 making class bindings special for franz allegro
 

-----------------------------------------------------------------------------------
|#



(defpackage apply-standard
  (:export defstandardclass handle-slot-desc make-eulisp-class-id))

#-:cmu (in-package apply-standard)
#+:cmu (in-package 'apply-standard)
(defun make-eulisp-class-id (identifier)
  (intern (concatenate 'string "<" (symbol-name identifier) ">")))

(defclass <defstandardclass-handler> ()
  ((state-key :reader state-key
              :initarg :key)
   (state-handler :reader state-handler
                     :initarg :handler)
   (result-handler :reader result-handler
                   :initarg :result)
   (accumulator :accessor accumulator
                :initform () )))

(defvar *defstandardclass-handlers*)
(setq *defstandardclass-handlers* nil)

(defun define-defstandardclass-handler (key element-handler result-handler)
(if (find key *defstandardclass-handlers* :key #'state-key)
   (error "defstandardclass-handler for key ~A already exists" key)
   (setq *defstandardclass-handlers* 
         (cons (make-instance '<defstandardclass-handler> 
                 :key key :handler element-handler :result result-handler)
               *defstandardclass-handlers*))))

(defun get-defstandardclass-state (key)
  (accumulator (find key *defstandardclass-handlers* :key #'state-key)))

(defun new-name (prefix name suffix &optional (trim-bag ""))
  (intern (concatenate 'string prefix (string-trim trim-bag (string name)) suffix)
          (symbol-package name)))

(defvar *standard-slot-options* ())
(setq *standard-slot-options* '(:accessor))

(defun handle-slot-desc (class-name slot-desc)
  (cond ((null slot-desc) nil)
        ((eq slot-desc :slots) nil)
        ((symbolp slot-desc) 
         (handle-slot-desc class-name
                           `(,slot-desc ,@*standard-slot-options*)))
        (t `(,(first slot-desc) 
             ,@(handle-structured-slot-desc (first slot-desc) (rest slot-desc) 
                                            nil)))))

(defun handle-structured-slot-desc (name options reader-or-accessor?)
(if (null options) nil
    (case (first options)
      (:reader (if (not reader-or-accessor?)
                 `(:reader ,(new-name "?" name "") 
                           ,@(handle-structured-slot-desc 
                              name (rest options) t))
                 (handle-structured-slot-desc name (rest options)
                                              reader-or-accessor?)))
      (:accessor (if (not reader-or-accessor?)
                   `(:accessor ,(new-name "?" name "") 
                               ,@(handle-structured-slot-desc 
                                  name (rest options) t))
                   (handle-structured-slot-desc name (rest options)
                                                reader-or-accessor?)))
      (:writer `(:writer ,(new-name "!" name "") 
                         ,@(handle-structured-slot-desc name (rest options)
                                                        reader-or-accessor?)))
      (:initarg `(:initarg ,(intern (string name) (find-package "KEYWORD")) 
                           ,@(handle-structured-slot-desc name (rest options)
                                                          reader-or-accessor?)))
      (:standard-options (handle-structured-slot-desc 
                          name 
                          (append *standard-slot-options* (rest options))
                          reader-or-accessor?))
      (t `(,(first options) ,(second options)
           ,@(handle-structured-slot-desc name (cddr options)
                                          reader-or-accessor?)))
      )))

(define-defstandardclass-handler :slots 
  #'handle-slot-desc
  #'(lambda (result)
      (list (reverse result)            ; slots
            nil                         ; class options
            nil                         ; top-level forms
            )))

(define-defstandardclass-handler :define-defstandardclass-handlers 
  #'(lambda (class-name value) 
      (declare (ignore class-name))
      (apply #'define-defstandardclass-handler value))
  #'(lambda (result) 
      (declare (ignore result))
      nil))

(define-defstandardclass-handler :default-slot-options 
  #'(lambda (class-name value) 
      (declare (ignore class-name))
      (setq *standard-slot-options* value))
  #'(lambda (result) 
      (declare (ignore result))
      nil))

(define-defstandardclass-handler :predicate
  #'(lambda (class-name value) 
      (declare (ignore value))
      `(defun ,(new-name "" class-name "-P" "<>") (x) 
         (typep x ',class-name)))
  #'(lambda (result) 
      (list nil nil result)))

(defmacro defstandardclass (name supers &rest slots-and-options)
(let ((*defstandardclass-handlers* *defstandardclass-handlers*)
      (*standard-slot-options* *standard-slot-options*))
  (let ((state (find :slots *defstandardclass-handlers* 
                     :key #'state-key)))
    (mapc #'(lambda (element)
              (when (find element *defstandardclass-handlers* 
                          :key #'state-key)
                (setq state 
                      (find element *defstandardclass-handlers* 
                            :key #'state-key)))
              (let ((result (funcall (state-handler state) name element)))
                (when result (push result (accumulator state)))))
          slots-and-options))
  (let ((slots () ) 
        (class-options () ) 
        (top-level () ))
    (mapc #'(lambda (handler)
              (let ((result (funcall (result-handler handler) 
                                     (accumulator handler))))
                (setf (accumulator handler) nil)
                (when result 
                  (setq slots (append slots (first result)))
                  (setq class-options (append class-options (second result)))
                  (setq top-level (append top-level (third result))))))
          *defstandardclass-handlers*)
    `(progn (defclass ,name ,supers     ; it's the CL-defclass
              ,slots ,@class-options)
            (#+(and :franz-inc :allegro)defparameter
	     #-(and :franz-inc :allegro)setq 
	       ,name (find-class ',name))
            ,@top-level
            ',name))))

#|Examples

(defstandardclass <foo> ()
  bar
  (baz :reader :initform 123)
  (foobar :reader :standard-options)
  (foobarbaz :initarg :accessor)
  :predicate)

(defstandardclass <bar> ()
  :default-slot-options (:reader :initarg)
  :slots
  foo
  (bar :accessor :standard-options))

|#