;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: configuration -*-
#|
-----------------------------------------------------------------------------------
TITLE: interface to configuration of apply
-----------------------------------------------------------------------------------
File:    configuration.em
Version: 1.0 (last modification on Wed Aug 25 15:11:00 1993)
State:   published

DESCRIPTION:
the description of the content

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
e.u.kriegel

CONTACT: 
e.u.kriegel

HISTORY: 
Log for /export/home/saturn/imohr/Lisp/Apply/configuration.em[1.0]
	Wed Aug 25 15:36:14 1993 ukriegel@isst published $
 aux. fcns and defs for configuration tool and #+
 

-----------------------------------------------------------------------------------
|#

#module-name configuration
#module-import
(level-1-eulisp 
  (only (read-eulisp $eulisp-readtable) el-modules)
 (rename ((pushnew cl:pushnew)
          (member cl:member)
          (set-dispatch-macro-character cl::set-dispatch-macro-character)
          (error cl:error)
          (char= cl:char=)
          (not cl:not)
          (some cl:some)
          (every cl:every)
          (values cl:values))
   (only (values not some every pushnew member set-dispatch-macro-character error char=) common-lisp)))

#module-syntax-import 
(level-1-eulisp)
#module-syntax-definitions

;; local macro definitions

#module-header-end

;;exports
(export define-configuration configuration?)
;;definitions and init-forms

;;; -----------------------------------------------------------------------------------
;;; conditional reader macros
;;; -----------------------------------------------------------------------------------

(defun read-configuration-expression
       (s macro-char arg)
  (let ((conf (read-eulisp s))
        (expr (read-eulisp s)))
    (if (or (and (cl:char= macro-char #\+)
                 (check-configuration conf))
            (and (cl:char= macro-char #\-)
                 (cl:not (check-configuration conf))))
      expr
      (cl:values)
      )))

(defun check-configuration
       (conf)
  (if (consp conf)
      ()
      (error "~%Error wrong expression ~s for conditional read" conf))
  (let ((op (car conf)))
    (cond ((eq op 'eulisp-symbol::not)
           (cl:not (check-configuration (car (cdr conf)))))
          ((eq op 'eulisp-symbol::or)
           (cl:some #'check-configuration (cdr conf)))
          ((eq op 'eulisp-symbol::and)
           (cl:every #'check-configuration (cdr conf)))
          (t (configuration? (car conf) (car (cdr conf)))))))



(cl:set-dispatch-macro-character #\# #\+ #'read-configuration-expression
                              $eulisp-readtable)
(cl:set-dispatch-macro-character #\# #\- #'read-configuration-expression
                              $eulisp-readtable)
          
;;; -----------------------------------------------------------------------------------
;;; describe configuration
;;; -----------------------------------------------------------------------------------

(deflocal configuration-table ())


(defun define-configuration 
       (key value)
   (let ((val (cl:member key configuration-table :key #'car)))
    (if val
      (setf (cdr (car val))(cl:pushnew value (cdr (car val))))
      (cl:pushnew  (cons key (list value)) configuration-table))
    ()))

(defun configuration?
       (key value)
  (if (cl:member value (car(cl:member key configuration-table :key #'car)))
    t
    ()))

#module-end
