;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: compiler-conditions -*-
#|
-----------------------------------------------------------------------------------
TITLE: macros for compiler conditions
-----------------------------------------------------------------------------------
File:    compiler-conditions.em
Version: 1.6 (last modification on Fri Sep  3 10:55:07 1993)
State:   published

DESCRIPTION:
the description of the content

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
the original author

CONTACT: 
the person which is currently responsible for this file

HISTORY: 
Log for /export/home/saturn/imohr/Lisp/Apply/compiler-conditions.em[1.0]
	Wed Apr 14 09:13:48 1993 ukriegel@isst proposed $
 compiler conditions
 
compiler-conditions.em[1.1] Thu Apr 15 12:26:11 1993 ukriegel@isst save $
 [Thu Apr 15 12:19:51 1993] Intention for change:
 expose conditions
 done
 
compiler-conditions.em[1.2] Fri Apr 16 08:57:24 1993 ukriegel@isst proposed $
 [Fri Apr 16 06:36:33 1993] Intention for change:
 test.
 imports added, no-handler is called if signal returns nil
 
compiler-conditions.em[1.3] Thu Sep  2 14:43:38 1993 ukriegel@isst proposed $
 [Wed Sep  1 18:11:21 1993] Intention for change:
 imports
 done, onle level-0-eulisp imported
 
compiler-conditions.em[1.4] Thu Sep  2 15:24:12 1993 ukriegel@isst proposed $
 [Thu Sep  2 15:03:30 1993] Intention for change:
 expose of conditions deleted
 
compiler-conditions.em[1.5] Fri Sep  3 10:53:31 1993 ukriegel@isst save $
 [Fri Sep  3 10:52:03 1993] Intention for change:
 #-cmu for print-object
 #+:cltl2
 
compiler-conditions.em[1.6] Fri Sep  3 10:55:21 1993 ukriegel@isst published $
 [Fri Sep  3 10:54:43 1993] Intention for change:
 #+:cltl2
 

-----------------------------------------------------------------------------------
|#

#module-name compiler-conditions
#module-import
(level-0-eulisp 
 (only (get-option check-options) option-lists)
 (rename ((format cl:format)
          (defclass cl:defclass)
          (mapcar cl:mapcar)
          (make-instance cl:make-instance)
	  (error cl:error))
   (only (format defclass setf make-instance error) common-lisp)))
#module-syntax-import 
(level-0-eulisp)
#module-syntax-definitions

;; local macro definitions
(defmacro define-compiler-condition (name supers format . options)
  `(defcondition ,name ,supers
                           ((message-format :initform ,format :accessor message-format)
                            (message-format-options :initform ',options 
                                                    :accessor message-format-options))))

#module-header-end

;;exports
(export compiler-error define-compiler-condition)
;;definitions and init-forms





(defun compiler-error 
       (condition-class   continuation .  option-list) 
  (compiler-error-dispatch (cl:make-instance condition-class) 
                           continuation 
                           option-list))

(defgeneric compiler-error-dispatch 
  (condition  continuation  option-list))

(defmethod compiler-error-dispatch 
           ((condition-instance <condition>) continuation option-list)
  (let ((fmt (message-format condition-instance))
        (options (message-format-options condition-instance)))
    ;;check option list consistency
    (option-lists::check-options options nil nil option-list)
    (let ((fmt-args (cl:mapcar (lambda(x)
                                 (option-lists::get-option x option-list nil)) 
                               options)))
      (setf (condition-message condition-instance)
            (apply #'cl:format nil 
                   (cons fmt fmt-args )))
      (signal condition-instance continuation)
      (no-handler condition-instance continuation)
      )))

;(compiler-error <schnulli-condition> () :place 1 :arg 2)


(defmethod compiler-error-dispatch 
           (condition-instanz continuation  option-list)
  (signal condition-instanz continuation)
  (no-handler condition-instance continuation))


#+:cltl2 (cl:defmethod cl:print-object ((cond <condition>) stream)
  (cl:format stream "!!!~%Condition ~s signalled:~%~s~%" (cl:class-name(cl:class-of cond))
          (condition-message cond)))

#module-end


