;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: asm-ops -*-
#|
-----------------------------------------------------------------------------------
TITLE: Pseudo Operations for SUN/SPARC-Assembler
-----------------------------------------------------------------------------------
File:    asm-ops.em
Version: 1.0 (last modification on Thu Aug 12 12:26:44 1993)
State:   published

DESCRIPTION:
This modules provides some pseudo operations of the SUN-assembler needed for the
generation of data.

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:

CONTACT: 

HISTORY: 
Log for /export/home/saturn/imohr/Lisp/Apply/asm-ops.em[1.0]
	Tue Aug 17 14:25:09 1993 imohr@isst published $
 asm pseudo operations like .word
 

-----------------------------------------------------------------------------------
|#

#module-name asm-ops

#module-import
(level-1-eulisp list-ext
; el2lzs-literals
; code-identifier
; static-allocation
 machine-description
; expand-literal
 lzs
; lzs-mop
; accessors
 (only (format make-list char subseq prog1 mod
        princ alphanumericp find char-code)
   common-lisp))

#module-syntax-import 
(level-1-eulisp
 (only (with-output-to-string)
   common-lisp))

#module-syntax-definitions

#module-header-end

(export 
  .seg 
  .global
  .skip
  .byte
  .half
  .word
  .single
  .double
  .quad
  .asciz
  .align
  comment-line)

(export-syntax 
  with-label
  with-comment
  with-new-alignment)

;;; -----------------------------------------------------------------------------------
;;; environment macros to set labels, alignments and comments
;;; -----------------------------------------------------------------------------------

(defmacro with-label (label comment . body)
  `(dynamic-let ((*label* ,label)
                 (*label-comment* ,comment)) 
     ,@body))

(defmacro with-comment (comment . body)
  `(dynamic-let ((*comment* ,comment)) ,@body))

(defmacro with-new-alignment body
  `(dynamic-let ((*alignment* 1)
                 (*align* nil))
     ,@body))

;;; -----------------------------------------------------------------------------------
;;; pseudo-operations
;;; -----------------------------------------------------------------------------------

(defun .seg (space) 
  (dynamic-let ((*align* nil))
    (dynamic-setq *alignment* 1)
    (pseudo-op+ ^seg "\"~(~A~)\"" space)))

(defun .global (symbol) 
  (dynamic-let ((*align* nil))
    (pseudo-op ^global symbol)))

(defun .skip (n) 
  (prog1 
    (pseudo-op ^skip n)
    (unless (= 0 (mod n (dynamic *alignment*)))
      (dynamic-setq *alignment* 1))))

(defun .byte (value) 
  (.align 1)
  (pseudo-op ^byte value))

(defun .half (value) 
  (.align 2)
  (pseudo-op ^half value))

(defun .word (value) 
  (.align 4)
  (pseudo-op ^word value))

(defun .single (value) (pseudo-op+ ^single "0r~A" value))

(defun .double (value) (pseudo-op+ ^double "0r~A" value))

(defun .quad (value) (pseudo-op+ ^quad "0r~A" value))

(defun .asciz (string) 
  (.align 1)
  (pseudo-op+ ^asciz "\"~A\"" (convert-to-asm-string string)))

(defconstant $el-asm-special-chars '(
  (#\a . #\0)
  (#\b . #\backspace)
  (#\d . #\rubout)
  (#\f . #\page)
  (#\l . #\linefeed)
  (#\n . #\newline)
  (#\r . #\return)
  (#\t . #\tab)
  (#\v)
  (#\" . #\")
  (#\\ . #\\)
  (#\x)
  ))

(defun convert-to-asm-string (string)
    (with-output-to-string (asm-string)
      (cl:map nil
              (lambda (char)
                (princ (cond ((alphanumericp char) char)
                             ((find char " !#$%&'()*+,-./:;<=>?@[]^_`{|}~")
                              char)
                             ((eq char #\backspace) "\\b")
                             ((eq char #\page) "\\f")
                             ((eq char #\newline) "\\n")
                             ((eq char #\return) "\\r")
                             ((eq char #\tab) "\\t")
                             (t (format nil "\\~3,'0O" (char-code char))))
                       asm-string))
              string)))

(defun .align (boundary)
  ; the code for .align is generated by the next operation
  (if (or (= boundary 1)
          (<= boundary (dynamic *alignment*)))
    (dynamic-setq *align* nil)
    (dynamic-setq *align* boundary))
  (dynamic-setq *alignment* boundary))

;;; -----------------------------------------------------------------------------------
;;; basic code generating functions
;;; -----------------------------------------------------------------------------------

(defvar *label* nil)
(defvar *comment* nil)
(defvar *label-comment* nil)
(defvar *align* nil)
(defvar *alignment* 1)

(defun pseudo-op (op . args)
  (apply #'pseudo-op+ op "~@{~A~#^,~}" args))

(defun pseudo-op+ (op arg-format . args)
  (prog1
    (format (dynamic code-output) 
            ; alignment
            ; label and label comment
            ; operation and operands
            ; operation comment
            "~%~@[~12T.align~20T~A~%~]~
             ~:[~*~;~:*~A:~@[~20T! ~A~]~%~]~
             ~12T.~(~A~) ~20T~? ~
             ~@[~40T! ~A~]"
            (dynamic *align*)
            (dynamic *label*) (dynamic *label-comment*)
            op arg-format args 
            (dynamic *comment*))
    (dynamic-setq *label* nil)
    (dynamic-setq *comment* nil)
    (dynamic-setq *label-comment* nil)
    (dynamic-setq *align* nil)))

(defun comment-line (format-string . args)
  (format (dynamic code-output) "~2%!~?" format-string args))

#module-end
