;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: analyse-h -*-
#|
-----------------------------------------------------------------------------------
TITLE: definitions for the transformation from LZS to MZS
-----------------------------------------------------------------------------------
File:    analyse-h.em
Version: 1.7 (last modification on Tue Apr 20 14:38:12 1993)
State:   proposed

DESCRIPTION:
DOCUMENTATION:
NOTES:
REQUIRES:
PROBLEMS:
AUTHOR: Dr. Horst Friedrich
CONTACT: horst.friedrich@isst.fhg.de
HISTORY: 
Log for /tmp_mnt/home/saturn/imohr/Lisp/Apply/analyse-h.em[1.0]
	Fri Mar  5 12:03:47 1993 hfried@isst save $
 
analyse-h.em[1.1] Fri Mar  5 13:00:40 1993 hfried@isst save $
 [Fri Mar  5 12:04:16 1993] Intention for change:
 text
 text
 
analyse-h.em[1.2] Thu Mar 18 08:05:45 1993 hfried@isst save $
 text
 
analyse-h.em[1.3] Thu Mar 18 08:52:23 1993 hfried@isst proposed $
 
analyse-h.em[1.4] Wed Mar 24 13:47:41 1993 hfried@isst proposed $
 [Thu Mar 18 09:10:26 1993] Intention for change:
 + glob anna
 
analyse-h.em[1.5] Thu Mar 25 11:18:36 1993 hfried@isst proposed $
 [Wed Mar 24 14:52:30 1993] Intention for change:
 + gen-fun
 new head
 
analyse-h.em[1.6] Tue Apr 13 14:08:09 1993 hfried@isst proposed $
 [Thu Mar 25 11:53:38 1993] Intention for change:
 closures
 
analyse-h.em[1.7] Tue Apr 20 15:45:03 1993 hfried@isst proposed $
 [Tue Apr 13 14:14:48 1993] Intention for change:
 cast
 

-----------------------------------------------------------------------------------
|#

#module-name analyse-h
#module-import 
( level-1-eulisp 
  lzs
  mzs
  simple-programming
  accessors
  (only (assoc format) common-lisp)) 

#module-syntax-import 
( level-1-eulisp )

#module-syntax-definitions

;--- defmacro forms
;; local macro definitions

(defmacro defclass (name supers . slots)
  (make-class-definition name
                         supers 
                         slots))

#module-header-end

;  #######
;  exports
;  #######

;        ########################################################
(export  <cast>
         closure env pathes typepathes block 
         rec-calls calls tests moves
         $normal $data $closure
         $funcall warning
         *started-and-not-finished-functions* *counter* l2m-a 
         append-stat  cons-block a-number finish-a)
;        ########################################################

(defclass cast () (type :initform ()))

;--- definitions, exportations, initialization forms

;;-----------------------------------------------------------------------------------
;; global-environments
;;-----------------------------------------------------------------------------------

;       -------
(defvar closure  ())
;       -------
(defvar env       ())
;       ------
(defvar pathes ())
;       ----------
(defvar typepathes ())
;       ----------
(defvar block ())
;       -----
;;-----------------------------------------------------------------------------------
;; annotations for the function
;;-----------------------------------------------------------------------------------

;       --------
(defvar rec-calls ())
;       --------
(defvar calls    ())
;       ------
(defvar tests ())
;       -----
(defvar moves ())
;       -----
; function types
;            -------
(defconstant $normal 0)
;            -------
(defconstant $data   1)
;            --------
(defconstant $closure 2)
;            --------
(defconstant $funcall -99)
;            --------
;;-----------------------------------------------------------------------------------
;; local variables
;;-----------------------------------------------------------------------------------

;         ------------------------------------
(defvar *started-and-not-finished-functions* ())
;         ------------------------------------
(defvar *counter*                               1)
;         ---------

(defun a-number ()
  (let ((n (dynamic *counter*)))
    (setf (dynamic *counter*) (+ (dynamic *counter*) 1))
    n))


;;-----------------------------------------------------------------------------------
;;  generic-function
;;-----------------------------------------------------------------------------------

;           -----
(defgeneric l2m-a (context lzs-object))
;           -----

;      #######
(defun warning (string . args)
;      #######
  (apply #'format t string args))

;      ###########
(defun append-stat (list ele)
;      ###########
  (if (null list) (list ele)
      (progn (append-stat1 list (list ele))
             list)))

;      ------------
(defun append-stat1 (list ele)
;      ------------ 
  (if (null (cdr list))
    (setf (cdr list) ele)
    (append-stat1 (cdr list) ele)))

;           ########
(defgeneric finish-a (con var-or-constant))
;           ########

;      ##########
(defun cons-block (block pathes)
;      ##########
  (if pathes 
    (cons (cons block (car pathes))
          (cons-block block (cdr pathes)))
    ()))

#module-end
