module:		dylan-user
rcs-header:	$Header: library.dylan,v 1.1 94/06/28 23:06:55 wlott Exp $

//======================================================================
//
// Copyright (c) 1994  Carnegie Mellon University
// All rights reserved.
// 
// Use and copying of this software and preparation of derivative
// works based on this software are permitted, including commercial
// use, provided that the following conditions are observed:
// 
// 1. This copyright notice must be retained in full on any copies
//    and on appropriate parts of any derivative works.
// 2. Documentation (paper or online) accompanying any system that
//    incorporates this software, or any part of it, must acknowledge
//    the contribution of the Gwydion Project at Carnegie Mellon
//    University.
// 
// This software is made available "as is".  Neither the authors nor
// Carnegie Mellon University make any warranty about the software,
// its performance, or its conformity to any specification.
// 
// Bug reports, questions, comments, and suggestions should be sent by
// E-mail to the Internet address "gwydion-bugs@cs.cmu.edu".
//
//======================================================================

// The library "collection-extensions" contains a variety of small modules
// which are not in the core language but are expected to be generally useful.
// These include new collection classes implementing heaps (i.e. priority
// queues), "self organizing" lists, and subsequences (also known as
// "slices"), and a routines for efficient search and replace on
// <byte-string>s.  Documentation for these routines may be found in
// collection-extension.doc.

define library collection-extensions
  use dylan;
  export heap, solist, string-search, subseq;
end library collection-extensions;

define module heap
  // Since "<heap>" is a subclass of "<sequence>", most methods are simply
  // added to existing generic functions.  The only "new" operation is
  // "random-iteration-protocol".
  use dylan;
  export <heap>, random-iteration-protocol;
end module heap;

define module solist
  use dylan;
  export <so-list>;
end module solist;

define module string-search
  use dylan;
  use subseq;
  export
    find-first-key, find-last-key, substring-position, compile-substring,
    replace-substring;
end module string-search;

define module subseq
  use dylan;
  export subsequence, <subsequence>;
end module subseq;  

