/*

   values.c

   Copyright, 1993, Brent Benson.  All Rights Reserved.
   0.4 Revisions Copyright 1994, Joseph N. Wilson.  All Rights Reserved.
   
   Permission to use, copy, and modify this software and its
   documentation is hereby granted only under the following terms and
   conditions.  Both the above copyright notice and this permission
   notice must appear in all copies of the software, derivative works
   or modified version, and both notices must appear in supporting
   documentation.  Users of this software agree to the terms and
   conditions set forth in this notice.

*/

#include "values.h"
#include "prim.h"
#include "list.h"

/* primitives */

static struct primitive values_prims[] = 
{
  {"values", prim_0_rest, values},
};

/* function defintions */

void
init_values_prims (void)
{
  int num;
  
  num = sizeof (values_prims) / sizeof (struct primitive);
  init_prims (num, values_prims);
}

Object 
make_values (Object vals)
{
  Object obj;
  int i;

  obj = allocate_object (sizeof (struct values));
  VALUESTYPE (obj) = Values;
  VALUESNUM (obj) = list_length (vals);
  VALUESELS (obj) = (Object *) 
    checking_malloc (VALUESNUM(obj) * sizeof (Object));
  for ( i=0 ; i < VALUESNUM (obj) ; ++i )
    {
      VALUESELS(obj)[i] = CAR (vals);
      vals = CDR (vals);
    }
  return (obj);
}

Object
construct_values (int num, ...)
{
  Object obj;
  int i;
  va_list args;

  obj = allocate_object (sizeof (struct values));
  VALUESTYPE (obj) = Values;
  VALUESNUM (obj) = num;
  VALUESELS (obj) = (Object *) checking_malloc (num * sizeof (Object));
  va_start (args, num);
  for ( i=0 ; i < num ; ++i )
    {
      VALUESELS(obj)[i] = va_arg (args, Object);
    }
  va_end (args);
  return (obj);
}

Object
values (Object rest)
{
  if (NULLP (CDR (rest)))
    {
      return (CAR (rest));
    }
  else
    {
      return (make_values (rest));
    }
}
