/*

   slot.h

   Copyright, 1993, Brent Benson.  All Rights Reserved.
   0.4 Revisions Copyright 1994, Joseph N. Wilson.  All Rights Reserved.
   
   Permission to use, copy, and modify this software and its
   documentation is hereby granted only under the following terms and
   conditions.  Both the above copyright notice and this permission
   notice must appear in all copies of the software, derivative works
   or modified version, and both notices must appear in supporting
   documentation.  Users of this software agree to the terms and
   conditions set forth in this notice.

*/

#ifndef SLOT_H
#define SLOT_H

#include "object.h"

void init_slot_prims (void);
Object slot_name (Object slot);
Object slot_getter (Object slot);
Object slot_setter (Object slot);
Object slot_type (Object slot);
Object slot_init_value (Object slot);
Object slot_init_function (Object slot);
Object slot_init_keyword (Object slot);
Object slot_required_init_keyword (Object slot);
Object slot_allocation (Object slot);
Object slot_value (Object instance, Object name);
Object set_slot_value (Object instance, Object name, Object val);
Object make_slot_descriptor (unsigned char properties, Object getter,
			     Object setter, Object type, Object init,
			     Object init_keyword, Object allocation);

#endif
