/*

   object.c

   Copyright, 1993, Brent Benson.  All Rights Reserved.
   0.4 Revisions Copyright 1994, Joseph N. Wilson.  All Rights Reserved.
   
   Permission to use, copy, and modify this software and its
   documentation is hereby granted only under the following terms and
   conditions.  Both the above copyright notice and this permission
   notice must appear in all copies of the software, derivative works
   or modified version, and both notices must appear in supporting
   documentation.  Users of this software agree to the terms and
   conditions set forth in this notice.

*/

#include "object.h"

#ifdef SMALL_OBJECTS

enum objtype 
object_type (Object obj)
{
  if (POINTERP (obj))
    {
      return (PAIRTYPE (obj));
    }
  else if (IMMEDP (obj))
    {
      switch (SUBPART (obj))
	{
	case TRUESUB:   return (True);
	case FALSESUB:  return (False);
	case EMPTYSUB:  return (EmptyList);
	case CHARSUB:   return (Character);
	case EOFSUB:    return (EndOfFile);
	case UNSPECSUB: return (Unspecified);
	case UNINITSUB: return (UninitializedSlotValue);
	default:
	  error ("object with unknown immediate tag", make_integer (SUBPART (obj)), NULL);
	}
    }
  else
    {
      return (Integer);
    }

}

#endif
