/*

   file.c

   Copyright, 1993, Brent Benson.  All Rights Reserved.
   0.4 Revisions Copyright 1994, Joseph N. Wilson.  All Rights Reserved.
   
   Permission to use, copy, and modify this software and its
   documentation is hereby granted only under the following terms and
   conditions.  Both the above copyright notice and this permission
   notice must appear in all copies of the software, derivative works
   or modified version, and both notices must appear in supporting
   documentation.  Users of this software agree to the terms and
   conditions set forth in this notice.

*/

#include <stdio.h>
#include "file.h"
#include "read.h"
#include "eval.h"
#include "error.h"

/* primitives */

static struct primitive file_prims[] =
{
  {"load", prim_1, load},
};

/* function definitions */

void
init_file_prims (void)
{
  int num;

  num = sizeof (file_prims) / sizeof (struct primitive);
  init_prims (num, file_prims);
}

Object 
load (Object filename)
{
  char *str;
  FILE *fp;
  Object obj, res;

  if (! BYTESTRP (filename))
    {
      error ("load: argument must be a filename", filename, NULL);
    }
  str = BYTESTRVAL (filename);
  fp = fopen (str, "r");
  if (! fp)
    {
      error ("load: cannot open file", filename, NULL);
    }
  while ((obj = read_object (fp)) != eof_object)
    {
      res = eval (obj);
    }
  return (res);
}
