/*

   env.h

   Copyright, 1993, Brent Benson.  All Rights Reserved.
   0.4 Revisions Copyright 1994, Joseph N. Wilson.  All Rights Reserved.
   
   Permission to use, copy, and modify this software and its
   documentation is hereby granted only under the following terms and
   conditions.  Both the above copyright notice and this permission
   notice must appear in all copies of the software, derivative works
   or modified version, and both notices must appear in supporting
   documentation.  Users of this software agree to the terms and
   conditions set forth in this notice.

*/

#ifndef ENV_H
#define ENV_H

#include "object.h"

struct binding
{
  Object sym, val, type;
  struct binding *next; /* in top_level_env hash chain */
};

struct frame
{
  int size;
  struct binding **bindings;
  struct frame *next;
};

extern struct frame *the_env;

void add_top_level_binding (Object sym, Object val);
void push_scope (void);
void pop_scope (void);

/* Warning!!! - you can't mix calls to add_bindings() and
   add_binding() within the same frame.  Things will get
   hopelessly screwed up.
*/
void add_bindings (Object syms, Object vals);
void add_binding (Object sym, Object val);
int change_binding (Object sym, Object val);

Object symbol_value (Object sym);
void modify_value (Object sym, Object new_val);
struct frame *current_env (void);
void unwind_to_exit (Object exit_sym);
struct binding *symbol_binding_top_level (Object sym);

#endif
