#include <string.h>
#include "xlisp.h"
#include "iview.h"
#include "stmem.h"

/**************************************************************************/
/**                                                                      **/
/**                        General Definitions                           **/
/**                                                                      **/
/**************************************************************************/

#define MOUSE_TOLERANCE 0

typedef struct {
  LVAL Object;                                /* elements of window_data */
  int idleOn;                                 /* elements of window_data */
  int mouse_x, mouse_y;                       /* elements of window_data */
  IVIEW_WINDOW window;
  int (*FreeMem)(HWND);
  ColorCode backColor, drawColor;
  int canvasWidth, canvasHeight;
  int lineType, drawMode, lineWidth;
  long RefCon;
  int use_color;
  int hasHscroll, hasVscroll, view_h, view_v;
  int v_scroll_inc[2], h_scroll_inc[2];
  int initialized;
  int symbolMode;
  int cursor;
  RECT clip_rect;
  int clipped;
  LOGPEN drawPen;
  int rect_offset;
} StGWWinInfo;

/* Access Defines */
#define SETWINOBJECT(w, d) SetWindowLong((HWND) (w), 0, (LONG) (d))
#define GETWINOBJECT(w) ((LVAL) GetWindowLong((HWND) (w), 0))
#define SETGWINFO(w, d) SetWindowLong((HWND) (w), 4, (LONG) (d))
#define GETGWINFO(w) ((StGWWinInfo *) GetWindowLong((HWND) (w), 4))

/* GDI defines */
#define GET_DC(w) (currentDC ? currentDC : GetDC((HWND) (w)))
#define RELEASE_DC(w, d) if (!currentDC) ReleaseDC((HWND) (w), (HDC) (d))
#define GET_DRAW_PEN(g) ((g)->drawPen)
#define RELEASE_PEN(p) DeleteObject(p);
#define SET_PEN(h,g) SelectObject(h, CreatePenIndirect(&GET_DRAW_PEN(g)))
#define RESTORE_PEN(h,p) RELEASE_PEN(SelectObject(h,p))
#define GET_DRAW_BRUSH(g) CreateSolidBrush(get_color((g)->drawColor))
#define GET_ERASE_BRUSH(g) CreateSolidBrush(get_color((g)->backColor))
#define SET_DRAW_BRUSH(h,g) SelectObject(h, GET_DRAW_BRUSH(g))
#define SET_ERASE_BRUSH(h,g) SelectObject(h, GET_ERASE_BRUSH(g))
#define RELEASE_BRUSH(b) DeleteObject(b)
#define RESTORE_BRUSH(h,b) RELEASE_BRUSH(SelectObject(h,b))

/* function prototypes */
void xlfail(char *);
long FAR PASCAL IVWinProc(HWND, WORD, WORD, LONG);
void StGWSetClipRect(StGWWinInfo *, int, int, int, int, int);
char *StGWObWinInfo(LVAL);
void StGWGetAllocInfo(LVAL, char **, int *, int *, int *, int *, int *);
void StPerror(char *);
void set_iview_window_address(IVIEW_WINDOW, LVAL);
void set_iview_address(IVIEW_WINDOW, LVAL);
LVAL send_message(LVAL, LVAL);
void SysBeep(int);
void StGWObDoClobber(LVAL);
IVIEW_WINDOW GETWINDOWADDRESS(LVAL);
LVAL slot_value(LVAL, LVAL);
LVAL cvfixnum(FIXTYPE);
LVAL xlbadtype(LVAL);
LVAL xltoofew(void);
void xltoomany(void);
POINT ListToPoint(LVAL);
void StGWSetScroll(StGWWinInfo *, int, int, int);
void StGWObDoKey(LVAL, unsigned char, int, int);
void StGWObDoMouse(LVAL, int, int, MouseEventType, MouseClickModifier);
int StGWIdleOn(StGWWinInfo *);
char *StGWObWinInfo(LVAL);
HCURSOR get_cursor(unsigned int);
void init_msw_cursors(void);
void init_msw_colors(void);
void StGWObDoIdle(LVAL);
unsigned long get_color(unsigned int);
void StGWObRedraw(LVAL);
void StGWObResize(LVAL);
int valid_iview_window_address(LVAL);
char *StCalloc(int, int);
int StScreenHasColor(void);
void init_msw_symbols(void);
void init_msw_buffer(void);
void cleanup_msw_symbols(void);
void StGWResetBuffer(void);
void StGetScreenSize(int *, int *);
void xexit(void);
void StGWGetViewRect(StGWWinInfo *, int *, int *, int *, int *);
void StGWStartBuffering(StGWWinInfo *);
void StGWBufferToScreen(StGWWinInfo *, int, int, int, int);
int IViewInternalIsLinked(IVIEW_WINDOW);
void IViewUnlinkWindow(IVIEW_WINDOW);
void StWSetSize(IVIEW_WINDOW, int, int, int);
void StShowWindow(IVIEW_WINDOW);
void StGWInitialDraw(StGWWinInfo *);
void init_msw_text(void);
void cleanup_msw_text(void);
void StGWSetClipRect(StGWWinInfo *, int, int, int, int, int);
BOOL InitApplResizeBrush(HANDLE);
char *getdosenv(char *);
char *realloc(char *, unsigned);
