#include <windows.h>
#include "winutils.h"
#include <dos.h>

#define ENVBUFSIZE 20
static char envbuf[ENVBUFSIZE];

static double dbltime(struct time *tm)
{
  return(3600.0*tm->ti_hour+60.0*tm->ti_min+tm->ti_sec+0.01*tm->ti_hund);
}

void Delay(unsigned n)
{
  double first, second;
  struct time tm;

  gettime(&tm);
  first = 1000.0 * dbltime(&tm);
  do {
    gettime(&tm);
    second = 1000.0 * dbltime(&tm);
  } while (second - first < n);
}

void SysBeep(int n)
{
  for (; n > 0; n -= 10)
    MessageBeep(0);
}

char *getdosenv(char *s)
{
  LPSTR p = GetDOSEnvironment();
  int n, k;

  if (strlen(s) + 2 > ENVBUFSIZE) return(NULL);

  sprintf(envbuf, "%s=", s);
  while ((n = strlen(p)) != 0) {
    k = strlen(envbuf);
    if (strncmp(envbuf, p, k) == 0)
      return(p+k);
    p += n + 1;
  }
  return(NULL);
}

void FlushAllEvents(void)
{
  MSG msg;

  while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE | PM_NOYIELD));
}

int WarningBox(char *msg)
{
  SysBeep(10);
  return(MessageBox(GetFocus(),
		    (LPSTR) msg,
		    "XLISP-STAT Skeleton",
		    MB_ICONASTERISK | MB_OK));
}

int OKorCancelBox(char *msg)
{
  return(MessageBox(GetFocus(),
		    (LPSTR) msg,
		    "XLISP-STAT Skeleton",
		    MB_ICONQUESTION | MB_OKCANCEL));
}

