;;; (C) Copyright 1990-1993 by Wade L. Hennessey. All rights reserved.

(in-package "W")

(use-package "EXTENSIONS")

(defun pwd () (default-directory))
(defun cd (dir) (setf (default-directory) dir))
(shadow '("CONSTANT" "COLLECT"))

(defmacro select (key-form &rest cases)
  (let ((key (gensym "KEY")))
    `(let ((,key ,key-form))
      (cond ,@(loop for (case . consequent) in cases
		    collect (cons (if (member case '(t otherwise))
				      t
				      (if (atom case)
					  `(eql ,key ,case)
					  `(or ,@(loop for c in case
						  collect `(eq ,key ,c)))))
				  consequent))))))

(defun shell (command-line)
  (process-exit-code (run-program "sh" `("-c" ,command-line) :output t)))

