/*  (C) Copyright 1990-1994 by Wade L. Hennessey. All rights reserved. */

#include "lisp.h"
#include <sys/time.h>
#include <sys/resource.h>

#ifdef mips
#include <time.h>
#endif

int start_realtime;

int unix_time_of_day ()
{
  struct timeval tp;
  struct timezone tzp;

  gettimeofday(&tp,&tzp);
  return(tp.tv_sec);
}

/* Is this really needed? */
void init_run_time()
{
  clock();			/*  start the runtime clock */
}

int timeval_to_internal_time(tp)
     struct timeval *tp;
{
  return(tp->tv_sec * 100 + tp->tv_usec / 10000);
}

int internal_system_run_time()
{
#ifndef SYSV
  struct rusage stats;

  getrusage(RUSAGE_SELF,&stats);
  return(timeval_to_internal_time(&(stats.ru_stime)));
#else
  return(0);
#endif
}

int internal_user_run_time()
{
#ifndef SYSV
  struct rusage stats;

  getrusage(RUSAGE_SELF,&stats);
  return(timeval_to_internal_time(&(stats.ru_utime)));
#else
  return(0);
#endif
}


int internal_real_time ()
{
  struct timeval tp;
  struct timezone tzp;

  gettimeofday(&tp,&tzp);
  tp.tv_sec = tp.tv_sec - start_realtime;
  return(timeval_to_internal_time(&tp));
}

void init_real_time()
{
  struct timeval tp;
  struct timezone tzp;

  gettimeofday(&tp,&tzp);
  start_realtime = tp.tv_sec;
}


#ifdef SYSV
int unix_timezone()
{
  extern time_t timezone, altzone;
  tzset();
  return(timezone / 3600);
}

int unix_daylight_savings_time()
{
  extern int daylight;

  tzset();
  return(daylight);
}
#else
int unix_timezone()
{
  struct timeval tp;
  struct timezone tzp;

  gettimeofday(&tp,&tzp);
  return(tzp.tz_minuteswest / -60);
}

int unix_daylight_savings_time()
{
  struct timeval tp;
  struct timezone tzp;

  gettimeofday(&tp,&tzp);
  return(tzp.tz_dsttime);
}
#endif


