/* Based on a dynamic loader written in C++ by:
  Glenn Gribble			glenn@synaptics.com	uunet!synaptx!glenn
  Synaptics, Inc.		(408) 434-0110
  2860 Zanker Road, Suite 105	(408) 434-9819 FAX
  San Jose, CA 95134

 Copyright (C) 1990 by Glenn Gribble; all rights are reserved.
 This program may be used for any purposes including inclusion in
 for profit programs.  If the source is copied, the copyright notice
 must be included.  Please send bug fixes/reports to glenn@synaptics.com
 This program is distributed without any warranty.

  */

typedef struct reloc_info_68k   reloc_info_type;

unsigned symTable::doReloc(reloc_info_type *rl,
		       int	relocSize,
		       register	memptr	seg)
{
  unsigned failed = FALSE;

  int numReloc = relocSize / sizeof(reloc_info_type);

  for (int i = 0; i < numReloc; i++) {
    register reloc_info_type& R = rl[i];

    register long addMe = 0;

    if (R.r_extern) {
      /* If external, then this is relative to an external symbol */
      nlist *nl = value(R.r_symbolnum);
      if (nl != NULL)
	addMe = nl->n_value;
      else {
	error("doReloc: undef symbol # %d", R.r_symbolnum);
	failed = TRUE;
      }
    } else {
      switch (R.r_symbolnum) {
      case N_TEXT:
      case N_DATA:
      case N_BSS:
	addMe = text_offset;	/* Same as data_offset */
	break;
      default:
	failed = TRUE;
	error("doReloc: Don't understand %s",
	      symbolNumToText(R.r_symbolnum));
      }
    }

    if (R.r_pcrel != 0) {
      error("doReloc: Don't grok r_pcrel=%d", R.r_pcrel);
      failed = TRUE;
    }
    if (R.r_baserel != 0) {
      error("doReloc: Don't grok r_baserel=%d", R.r_baserel);
      failed = TRUE;
    }
    if (R.r_jmptable != 0) {
      error("doReloc: Don't grok r_pcrel=%d", R.r_pcrel);
      failed = TRUE;
    }
    if (R.r_relative != 0) {
      error("doReloc: Don't grok r_relative=%d", R.r_relative);
      failed = TRUE;
    }
    
    switch (R.r_length) {
    case 0:
      *(char *)(seg+R.r_address) += (char )addMe;
      break;
    case 1:
      *(short*)(seg+R.r_address) += (short)addMe;
      break;
    case 2:
      *(long *)(seg+R.r_address) += (long )addMe;
      break;
    default:
      error("doReloc: Don't grok r_length=%d",R.r_length);
      failed = TRUE;
    }
  }

  if (failed)
    return FALSE;
  else
    return TRUE;
}

void symTable::showReloc(reloc_info_type *rl, int size, memptr seg)
{
  int nreloc = size / sizeof(reloc_info_type);
  for (int i = 0; i < nreloc; i++) {
    reloc_info_type& R = rl[i];
    const char *sym = "##?";
    if (R.r_extern) {
      nlist& N = realSymbols[R.r_symbolnum];
      sym = N.n_un.n_name;
    } else {
      sym = symbolNumToText(R.r_symbolnum);
    }

    long value = -1;
    switch (R.r_length) {
    case 0:
      value = *(char *)(seg+R.r_address);
      break;
    case 1:
      value = *(short*)(seg+R.r_address);
      break;
    case 2:
      value = *(long *)(seg+R.r_address);
      break;
    }
    info("%4d = %08x %12s pcr:%d len:%d ex:%d br:%d jmp:%d rel:%d",
	 R.r_address, value,
	 sym, R.r_pcrel, R.r_length,
	 R.r_extern,  R.r_baserel,   R.r_jmptable,
	 R.r_relative);
  }
}
