/*  (C) Copyright 1990-1994 by Wade L. Hennessey. All rights reserved. */

#include "lisp.h"
#include <signal.h>
#include <mips/inst.h>
#include <mips/cpu.h>
#include "bignum/BigZ.h"

extern void lisp_debug();

signal_handler (sig,code,scp)
     int sig, code;
     struct sigcontext *scp;

{
  unsigned long opcode, func, rs, rt, rd;
  union mips_instruction branch_instruction, exception_instruction;
     
  switch (sig) {

  case SIGFPE:
    switch (code) {
    case EXC_OV:
      /* The man page says this is how to get the instruction
	 that caused the execption */
      if(scp->sc_cause & CAUSE_BD){
	branch_instruction.word = *(unsigned long *)(scp->sc_pc);
	exception_instruction.word = *(unsigned long *)(scp->sc_pc + 4);
      } else {
	exception_instruction.word = *(unsigned long *)(scp->sc_pc);
      }

      opcode = exception_instruction.j_format.opcode;

      switch (opcode)  {
      case spec_op:
	func = exception_instruction.r_format.func; 
	switch (func) {
	case add_op:		/* integer_add overflow */
	  rs = exception_instruction.r_format.rs;
	  rt = exception_instruction.r_format.rt;
	  rd = exception_instruction.r_format.rd;
	  scp->sc_regs[rd] = (int)
	    addition_overflow_handler(FX_TO_INT(scp->sc_regs[rs]),
				      FX_TO_INT(scp->sc_regs[rt]));
	  
	  if (scp->sc_cause & CAUSE_BD) {
	    emulate_branch(scp, branch_instruction);
	  } else  {
	    scp->sc_pc += 4;
	  }
	  break;

	case sub_op:		/* integer_subtract underflow */
	  rs = exception_instruction.r_format.rs;
	  rt = exception_instruction.r_format.rt;
	  rd = exception_instruction.r_format.rd;
	  scp->sc_regs[rd] = (int) 
	    subtraction_overflow_handler(FX_TO_INT(scp->sc_regs[rs]),
					 FX_TO_INT(scp->sc_regs[rt]));
	  if (scp->sc_cause & CAUSE_BD) {
	    emulate_branch(scp, branch_instruction);
	  } else {
	    scp->sc_pc += 4;
	  }
	  break;			
			
	default:
	  printf("error");
	  lisp_debug();
	  break;
	}		
	break;

      default:
	printf("Unknown opcode caused an overflow\n");
	lisp_debug();
      }
      break;

    otherwise: printf("Unknown signal code for SIGFPE: %d\n",code);
      break;
    }
    break;

  case SIGTRAP:
  case SIGBUS:
  case SIGSYS:
  case SIGSEGV:
  case SIGILL:
  case SIGINT:
    p_lsp_ABORT(0);

  default:
    printf("Unknown signal: %d\n",sig);
    lisp_debug();
    break;
  }
}


