/*  (C) Copyright 1990-1992 by Wade L. Hennessey. All rights reserved. */

/* 
  compile with: cc -g -L/usr/lib/cmplrs/cc2.0/ bt.c -lexc 
 */

#include <stdio.h>
#include <signal.h>
#include <exception.h>
#include <sym.h>
#include <cmplrs/stsupport.h>
#include <filehdr.h>
#include <ldfcn.h>

#define SP_REG 29
#define RA_REG 31

/* HEY! This needs to be extended to map line->pc */
struct procedure_table_entry {
  unsigned i;
  unsigned adr;
  unsigned hiline;	
};


LDFILE *ldptr;
struct procedure_table_entry *proc_table = 0;

/* Return -1, 0, or 1 */
int address_signum(ptr1, ptr2)
     struct procedure_table_entry *ptr1, *ptr2;
{
  unsigned long a1 = ptr1->adr;
  unsigned long a2 = ptr2->adr;
  return((a1 > a2) - (a1 < a2));
}

sort_proc_table(char* exec_name)
{
  int ipd,j;

  ldptr = ldopen(exec_name, NULL);
  if (ldptr == 0) {
    printf("Cannot find any lineno info\n");
  }
  if (PSYMTAB(ldptr) == 0) {
    printf("Symbol table not found\n");
  } else  {
    ldreadst(ldptr, -1);
    ipd = SYMHEADER(ldptr).ipdMax;
    proc_table = (struct procedure_table_entry *)
      malloc(ipd * sizeof (struct procedure_table_entry));
    if (proc_table == 0) {
      perror("malloc failed");
      exit(1);
    }
    for (j = 0; j < ipd; j ++) {
      PDR pd;

      if (ldgetpd(ldptr, j, &pd) == FAILURE) {
	printf("you lose");
      }
      proc_table[j].adr = pd.adr;
      proc_table[j].i = j;
      if (pd.lnHigh == -1) {
	proc_table[j].hiline = proc_table[j-1].hiline;
      }
    }
    qsort(proc_table, ipd, sizeof (struct procedure_table_entry),
	  address_signum);
  }
}

lookup_proc_desc(unsigned long adr, pPDR pdr)
{
  int 	high,low,half,olow,ohigh,index;

  high = SYMHEADER(ldptr).ipdMax - 1;
  low = 0;
  while (low < high) {
    half = (low + high) / 2;
    olow = low;
    ohigh = high;
    ldgetpd(ldptr, half, pdr);
    if (adr == pdr->adr) {
      return 1;
    }
    if (adr < pdr->adr) {
      high = half;
    } else {
      low = half;
    }
    if ((low == olow) && (high == ohigh)) {
      ldgetpd(ldptr, high, pdr);
      if (adr == pdr->adr) {
	return 1;
      }
      if (adr > pdr->adr)
	return 1;
      ldgetpd(ldptr, low, pdr);
      if (adr == pdr->adr) {
	return 1;
      }
      if (adr > pdr->adr) return(1); else return(0);
    }
  }
}

/* C doesn't have multiple values, so we return the file_name
   in RETURN_FILE_NAME */
int line_number(unsigned long pc, char* return_file_name)
{
  unsigned long line,iline,ifd;
  char* file;
  PDR pd;
  
  if (lookup_proc_desc(pc, &pd) &&
      pd.iline != ilineNil && pd.isym != isymNil) {
    iline = pd.iline + ((pc - pd.adr)/4);
    if (iline >= SYMHEADER(ldptr).ilineMax) {
      printf("lineno error\n");
    }		
    line = PSYMTAB(ldptr)->pline[iline];
  } else {
    printf("cannot find lineno\n");
  }
  ifd = ld_ifd_symnum(ldptr, pd.isym);
  file = PFD(ldptr)[ifd].rss + PFD(ldptr)[ifd].issBase + PSYMTAB(ldptr)->pss;
  strcpy(return_file_name,file);
  return(line);
}

/* True if bit I is 1 in X */
bitsetp(unsigned long i,unsigned long x)
{
  return((x & (1 << i)));
}

backtrace(scp)
     /* losing mips cc can't hack the prototype form of this function */
     struct sigcontext *scp;	
{
  pRPDR desc;
  int pc,sp,frame_num,line_num;
  char file_name[1024];
  
  pc = scp->sc_pc;
  sp = scp->sc_regs[SP_REG];
  for (frame_num = 0; ; frame_num++) {
    desc = find_rpd(pc);
    line_num = line_number(pc,file_name);
    printf("#%d: %12s (pc 0x%08x at line %4d in file %s)\n",
	   frame_num,
	   _procedure_string_table + desc->irpss,
	   desc->adr,
	   line_num,
	   file_name);
    if (desc->pcreg == 0) return;
    /* Does proc save RA and are we past the header code that does the save? */
    if ((bitsetp(desc->pcreg,desc->regmask) && (pc >= (desc->adr + 8)))) { 
      pc = *((unsigned long *) (sp + desc->regoffset + desc->frameoffset));
    } else {
      pc = scp->sc_regs[RA_REG];
    }
    sp = sp + desc->frameoffset;
  }
}

pc_to_procedure_name(unsigned long pc,char *buffer)
{
  pRPDR desc;
  int line_num;
  char file_name[1024];
  
  desc = find_rpd(pc);
  line_num = line_number(pc,file_name);
  /* printf("%12s (pc 0x%08x at line %4d in file %s)\n",
	 _procedure_string_table + desc->irpss,
	 desc->adr,
	 line_num,
	 file_name);
	 */
  strcpy(buffer,_procedure_string_table + desc->irpss);
  return(strlen(buffer));
}


init_loader(char* exec_name)
{
  sort_proc_table(exec_name);
}




