#include <mips/regdef.h>

/*

   MIPS instructions that will generate overflow exceptions. 
   These are used to catch fixnum->bignum overflow cases.
   It would be really nice to inline some of these.

*/
	.text	
	.align	2

	.globl	integer_add
	.ent	integer_add
integer_add:
	.frame	sp, 0, ra
	add	v0, a0, a1
	j	ra
	.end	integer_add

	.globl	integer_subtract
	.ent	integer_subtract
integer_subtract:
	.frame	sp, 0, ra
	sub	v0, a0, a1
	j	ra
	.end	integer_subtract

	.globl	integer_multiply
	.ent	integer_multiply
integer_multiply:
	subu	sp, 24
	sw	ra, 20(sp)
	sd	a0, 24(sp)
	.frame  sp, 24, ra
	sra	a0, a0, 1
	mult	a0, a1
	mfhi	t0
	mflo	t1
	sra	t1, t1, 31
 	bne	t0, t1, bignum_case
	mflo	v0
	lw	ra, 20(sp)
	addu	sp, 24
	j	ra
bignum_case:
	jal	multiply_overflow_handler
	lw	ra, 20(sp)
	addu	sp, 24
	j	ra
	.end	integer_multiply

	.globl	copy_regs_to_stack
	.ent	copy_regs_to_stack
copy_regs_to_stack:
	.frame	sp, 0, ra
	sw	s0, 0(a0)
	sw	s1, 4(a0)
	sw	s2, 8(a0)
	sw	s3, 12(a0)
	sw	s4, 16(a0)
	sw	s5, 20(a0)
	sw	s6, 24(a0)
	sw	s7, 28(a0)
	sw	s8, 32(a0)
	j	ra
	.end	copy_regs_to_stack

