/*  (C) Copyright 1990-1992 by Wade L. Hennessey. All rights reserved. */

#include "lisp.h"

/* All of the evaluator could be (and once was) written entirely in Lisp.
   However, in order to make debugging evaluated code work well, 
   these evalator functions are written in C so that GDB can 
   recognize and manipulate them.
*/
/* HEY!!! Need an ansi version of this function */
LP eval_closure_code(va_alist) va_dcl
{
  LP env;
  LP name;
  LP formal_args; LP evaled_args; LP body;
  LP venv; LP fenv; LP tenv; LP benv;
  LP result;
  DYNAMIC_REST_HOLDER(rest_conses);
  int real_argc;
  ARGC argc;

  BEGIN_NON_ANSI_VAR_ARGS;
  argc = (ARGC) NEXT_VAR_ARG;

  real_argc = REAL_ARGC(argc);
  env = OE;
  DYNAMIC_RESTIFY(evaled_args,1,NEXT_VAR_ARG);
  END_VAR_ARGS;
  name = GET_OE_SLOT(env,0);
  formal_args = GET_OE_SLOT(env,1);
  body = GET_OE_SLOT(env,2);
  venv = GET_OE_SLOT(env,3);
  fenv = GET_OE_SLOT(env,4);
  tenv = GET_OE_SLOT(env,5);
  benv = GET_OE_SLOT(env,6);
  if (LISTP(formal_args)) {
    venv = (LP) p_lsp_EVAL_2DSIMPLE_2DEXTEND_2DVAR_2DENV
      (3, venv, formal_args, evaled_args);
    result = (LP) p_lsp_EVAL_2DSEQUENCE (MV_CALL(argc,5),
					 body, venv, fenv, tenv, benv);
  } else {
    /* We could do all this in Lisp, but then the correct VENV
       (including special bindings which aren't really in VENV)
       wouldn't be readily available to the debugger; hence this mess. */
    LP specials;
    LP special_values;
    BEGIN_UW_PROTECT_BODY
      BEGIN_MV_CALL(mv_holder,0);
      venv = (LP) p_lsp_EVAL_2DHAIRY_2DEXTEND_2DVAR_2DENV
	(MV_CALL(mv_holder,6),
	 venv, formal_args, evaled_args, fenv, tenv, benv);
    BEGIN_VAR_VALUES;
    NEXT_VAR_VALUE(mv_holder);	/* skip uninitialized first value */
    specials = NEXT_VAR_VALUE(mv_holder);
    special_values = NEXT_VAR_VALUE(mv_holder);
    END_VAR_VALUES;
    END_MV_CALL;
    result = (LP) p_lsp_EVAL_2DSEQUENCE (MV_CALL(argc,5),
					 body, venv, fenv, tenv, benv);
    BEGIN_UW_PROTECT_CLEANUP
      p_lsp_EVAL_2DUNDO_2DSPECIAL_2DBINDINGS(2,specials,special_values);
    CONTINUE_FROM_PROTECT;
  }
  /* UG! Don't let optimizer discard name.
     Shouldn't volatile work here??? It doesn't. */
  use_arg(name);
  return(result);
}

LP make_eval_closure(name, formal_args, body, venv, fenv, tenv, benv)
     LP name; LP formal_args;
     LP body; LP venv; LP fenv; LP tenv; LP benv;

{
  LP closure; LP oe;

  oe = NEW_OE(7);
  SET_OE_SLOT(oe,0,name);
  SET_OE_SLOT(oe,1,formal_args);
  SET_OE_SLOT(oe,2,body);
  SET_OE_SLOT(oe,3,venv);
  SET_OE_SLOT(oe,4,fenv);
  SET_OE_SLOT(oe,5,tenv);
  SET_OE_SLOT(oe,6,benv);
  closure = MAKE_CLOSURE(eval_closure_code,oe);
  return(closure);
}

use_arg(x)
{
  return(x);
}
