/*  (C) Copyright 1990-1992 by Wade L. Hennessey. All rights reserved. */

/* All closures should end on a 32-bit word boundry 

   HEY! Need to worry about I/D cache splits, write-through vs. copy back
   and IBUF problems on some machines. So far, SPARC seems to be an easy one.
*/

#ifdef M68K
typedef struct closure {
  unsigned short movl;
  LP env;
  LP oe_addr;
  unsigned short jmpl;
  LP code_ptr;
} CLOSURE;
#endif

#ifdef MIPS			/* Little Endian */
#define HI_16(x) (((unsigned long) x) >> 16)
#define LOW_16(x) (((unsigned long) x) & 0xffff)

typedef struct mips_closure {
  unsigned short oe_hi;
  unsigned short lui_t0;

  unsigned short code_ptr_hi;
  unsigned short lui_t1;

  unsigned short oe_addr_hi;
  unsigned short lui_t2;

  unsigned short oe_addr_low;
  unsigned short ori_t2;

  unsigned short code_ptr_low;
  unsigned short ori_t1;

  unsigned short oe_low;
  unsigned short ori_t0;

  unsigned long jr_t1;

  unsigned long sw_t0_t2;  
} CLOSURE;
#endif

/* HEY! I think we can  elimintate the save/restore by using %g2 -> %g4
   as temp regs. SPARC ABI says:

   %g0 is always zero
   %g1 is a caller-save `very temp'
   %g2..%g4 are reserved for application code and may not
            be modified by libraries
   %g5..%g7 may be read but not written by an application
           (the analog of %g2..%g4 for libraries)
*/

#ifdef SPARC
#define HI22(x) ((((unsigned long) x) & 0xfffffc00) >> 10)
#define LOW10(x) (((unsigned long) x) & 0x3ff)

typedef struct sparc_closure {
  unsigned long save;

  unsigned long sethi_oe_opcode:10;
  unsigned long sethi_oe:22;

  unsigned long add_oe_opcode:19;
  unsigned  long add_oe:13;

  unsigned long sethi_oe_addr_opcode:10; 
  unsigned long sethi_oe_addr:22;

  unsigned long sethi_code_opcode:10;
  unsigned  long sethi_code:22;

  unsigned long st_oe_opcode:19;
  unsigned long st_oe:13;

  unsigned long jmpl_opcode:19;
  unsigned long jmpl_code:13;

  unsigned long restore;
} CLOSURE;
#endif
