/*  (C) Copyright 1990-1992 by Wade L. Hennessey. All rights reserved. */

/*
  Port specific closure code. The garbage collector also contains
  some port specific closure code, might want to move it into this
  file someday. Better yet, make port specific versions of this file.
  */

#include "lisp.h"
#include "closure.h"

LP OE = 0;				/* outer env is passed through this */

LP new_closure(code, env)
     LP code; LP env;
{
  CLOSURE *trampoline;
  LP procedure;

  trampoline = (CLOSURE *)
               (alloc_bytes(sizeof(CLOSURE),TYPE_CLOSURE) - 1);

#ifdef M68K
  trampoline->movl = 0x23fc;
  trampoline->env = env;
  trampoline->oe_addr = (LP) &OE;
  trampoline->jmpl = 0x4ef9;  
  trampoline->code_ptr = code;
#endif

#ifdef MIPS
  trampoline->lui_t0 = 0x3c08;
  trampoline->oe_hi = HI_16(env);
  trampoline->lui_t1 = 0x3c09;
  trampoline->code_ptr_hi = HI_16(code);
  trampoline->lui_t2 = 0x3c0a;
  trampoline->oe_addr_hi = HI_16(&OE);
  trampoline->ori_t2 = 0x354a;
  trampoline->oe_addr_low = LOW_16(&OE);
  trampoline->ori_t1 = 0x3529;
  trampoline->code_ptr_low = LOW_16(code);
  trampoline->ori_t0 = 0x3508;
  trampoline->oe_low = LOW_16(env);
  trampoline->jr_t1 = 0x01200008;
  trampoline->sw_t0_t2 = 0xad480000;
#endif 

#ifdef SPARC
 trampoline->save = 0x9de3bf88;
 trampoline->sethi_oe_opcode = 0x84;
 trampoline->sethi_oe = HI22(env);
 trampoline->add_oe_opcode = 0x50021;
 trampoline->add_oe = LOW10(env);
 trampoline->sethi_oe_addr_opcode = 0x8c;
 trampoline->sethi_oe_addr = HI22(&OE);
 trampoline->sethi_code_opcode = 0x94;
 trampoline->sethi_code = HI22(code);
 trampoline->st_oe_opcode = 0x70123;
 trampoline->st_oe = LOW10(&OE);
 trampoline->jmpl_opcode = 0x40E25;
 trampoline->jmpl_code = LOW10(code);
 trampoline->restore = 0x81e80000;
#endif 

  procedure = NEW_PROCEDURE;
  HEADER(procedure) =  (CLOSED_PROCEDURE_FLAG << 8) + TAG(procedure);
  DEREF(procedure) = (unsigned long) trampoline;
  return(procedure);
}

LP closure_oe(procedure)
     LP procedure;
{
  CLOSURE *trampoline;
  LP oe;

  trampoline = (CLOSURE *) (LDREF(procedure,PROCEDURE,code_pointer));
#ifdef SPARC
  oe = (LP) ((trampoline->sethi_oe << 10) + trampoline->add_oe);
#else
    fixme;
#endif
  return(oe);
}

/* LEN must be > 0 since we need space for a forwarding pointer */
LP new_oe(len)
     int len;
{
  LP ptr;
  ptr = alloc_words(len,TYPE_OE);
  return(ptr);
}
