/* 
Copyright (C) 1993 by Roger Sheldon

This file is part of the Lily C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "global.h"
#include "lily.h"
#include <fstream.h>

// Define two streams for comparing output, the first is hardwired, second
// is the output of Lily functions, which should match the first stream.

ofstream expected("testlily.ctrl");
ofstream actual("testlily.act");

// IMPORTANT: Make sure COUNTOBS is #defined in object.h

// This program tests Lily functions to make sure they do what they're
// expected to and also to make sure that Lily's garbage collector
// is working properly.

//ostream s("out", "w");

// Each test function test_foo is expected print using this format:
//
// *** foo ***
// expects:
// ...
// results:
// ...

// Clean test functions

void test_equal() {
    LObject l1 = list("a", "b");
    LObject l2 = list("c", "d");
    cout << "*** equal ***\nexpects:\n"
         << "t\n"
         << "results:\n"
         << equal(l1, l1)
         << "\n\n";
    cout << "*** equal ***\nexpects:\n"
         << "nil\n"
         << "results:\n"
         << equal(t, l1)
         << "\n\n";
    cout << "*** equal ***\nexpects:\n"
         << "nil\n"
         << "results:\n"
         << equal(l1, t)
         << "\n\n";
}


void test_Append() {
    LObject l1 = list("a", "b");
    LObject l2 = list("c", "d");
    cout << "*** Append ***\nexpects:\n"
         << "(a b c d)\n"
         << "results:\n"
         << Append(l1, l2)
         << "\n\n";
    cout << "*** Append ***\nexpects:\n"
         << "(c d)\n"
         << "results:\n"
         << Append(nil, l2)
         << "\n\n";
}

void test_mapcar() {
    cout << "*** mapcar ***\nexpects:\n"
         << "(1 2)\n"
         << "results:\n"
         << mapcar(first, list(list(1, 3), list(2, "foo")))
         << "\n\n";
    cout << "*** mapcar ***\nexpects:\n"
         << "((1) (2) (3))\n"
         << "results:\n"
         << mapcar(list, list(1, 2, 3))
         << "\n\n";
    LObject l = list(1, 2, 3);
    cout << "*** mapcar ***\nexpects:\n"
         << "((1 a) (2 b) (3 c))\n"
         << "results:\n"
         << mapcar(list, l, list("a", "b", "c"))
         << "\n\n";
}

void test_set_difference() {
    LObject l = list(list("controls", "concepts"),
                    list("switches", "controls"),
                    list("lvalve", "switches"),
                    list("rvalve", "switches"),
                    list("wings", "concepts"));

    cout << "*** set_difference ***\nexpects:\n"
         << "(concepts)\n"
         << "results:\n"
         << set_difference(mapcar(second, l), mapcar(first, l))
         << "\n\n";
}


// Dirty test functions -- clean them up when you get a chance:

void test_math() {
    LObject a = 5;
		LObject b = (LObject)3 * a;
    LObject c = a * b - a;
    cout << "test_math\n" << a << " " << b << " " << c << "\n";
    c += b;
    cout << c << "\n";
    c -= 100;
    cout << c << "\n";
    cout << (LObject)(b == c) << "\n";
}


LObject w() { cout << "WWWWWW\n"; return nil; }
LObject x() { cout << "XXXXX\n"; return nil; }
LObject y() { cout << "YYYYY\n"; return list("ok", t, nil, "slkdf"); }
LObject a() { return nil; }      //or(x(),y()); }
LObject b() { return nil; }      //return or3(w(),x(),y()); }
void test_or() {
//  cout << "test_or\n" << a() << "\n" << b() << "\n";
    cout << "test_or\n" << a() << "\n";
}

void test_cons() {
    LObject a = cons(t, nil);
}

void test_reverse() {
    LObject l1 = list("a", "b");
    cout << "test_reverse\n";
    cout << l1 << "\n";
    cout << reverse(l1) << "\n";
}

void test_reverse1() {
    LObject l1 = list("a", "b", list(t, "c", t, list(), list(list("hoople"))));
    cout << "test_reverse1\n";
    cout << l1 << "\n";
    cout << reverse(l1) << "\n";
}

void test_length() {
    LObject l1 = list("a", "b", list(t, "c", t, list(), list(list("hoople"))));
    cout << "test_length\n";
    cout << l1 << "\n" << length(l1) << "\n";
}

void test_assoc() {
    LObject l1 = list("a", "b");
    LObject l2 = list("foo", "c");
    LObject l5 = list(l1, l2);
    cout << "test_assoc\n";
    cout << assoc("foo", l5) << "\n";
    cout << assoc("a", l5) << "\n";
    cout.flush();
}

void test_atom() {
    LObject l = cons(t, nil);
    cout << "test_atom\n";
    cout << atom(nil);
    cout << "\n" << atom(t);
    cout << "\n" << atom(l);
    cout.flush();
}
void test_copy_list() {
    LObject l1 = list("a");
    LObject l2 = list(nil, t, l1, nil, l1);  
    LObject l3 = copy_list(l2);
    cout << "\ntest_copy_list";
    cout << "\n" << l3 << "\n";
    cout.flush();
}
void test_copy_tree() {
    LObject l2 = list(list(t, "ok"), nil, list(nil), nil);
    cout << "test_copy_tree\n" << l2 << "\n" << copy_tree(l2) << "\n";
    cout.flush();
}

void test_nconc() {
    LObject l1 = list("a", nil, t, "c");
    LObject l2 = list(list(t, "ok"), nil, list(nil), nil);
    cout << "test_nconc\n" << l1 << "\n" << l2 << "\n";
    nconc(l1, l2);
    cout << "test_nconc\n" << l1 << "\n" << l2 << "\n";
    cout.flush();
}

/*
void test_() {
    cout << "\ntest_";
    cout << "\n" <<;
}
*/

main() {
    int i;
    i = Base::count; test_equal();     	DET(i!=Base::count);
		i = Base::count; test_Append();     DET(i!=Base::count);
    i = Base::count; test_mapcar();     DET(i!=Base::count);
    i = Base::count; test_set_difference();     DET(i!=Base::count);
    i = Base::count; test_length();     DET(i!=Base::count);
    i = Base::count; test_cons();       DET(i!=Base::count);
    i = Base::count; test_reverse();    DET(i!=Base::count);
		i = Base::count; test_reverse1();   DET(i!=Base::count);
    i = Base::count; test_assoc();      DET(i!=Base::count);
    i = Base::count; test_atom();       DET(i!=Base::count);
    i = Base::count; test_copy_list();  DET(i!=Base::count);
    i = Base::count; test_copy_tree();  DET(i!=Base::count);
    i = Base::count; test_nconc();      DET(i!=Base::count);
//    i = Base::count; test_math();       DET(i!=Base::count);
    i = Base::count; test_length();     DET(i!=Base::count);
//  i = Base::count; test_or();         DET(i!=Base::count);
/*
    i = Base::count; test_();           DET(i!=Base::count);
*/
}
