/* 
Copyright (C) 1993 by Roger Sheldon

This file is part of the Lily C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef Symbol_h
#define Symbol_h

// This file includes the Symbol and special_Symbol classes.

#include "object.h"

class Symbol : public Base {
protected:
    char    *value;
public:
    Symbol(char *s);
    ~Symbol();

    Base &      Atom();
    Base &      Copy();
    Base &      Equal(Base &a);
    ostream&    Print(ostream& s=cout);
//  Base &      Print();
    char *      Symbol_name();
    LObject_type Type();
    Base &      Typep(LObject_type);
};

class special_Symbol : public Symbol {  // to make special Symbol t
public:
    special_Symbol(char *s);
    Base *  Ref();
    void    Deref();
};

/////////////////////////////////////////////////////////// conditional inlining

#ifndef NOINLINE
    #include "symbol.c"
#endif

#endif  // #ifndef Symbol_h
