/* 
Copyright (C) 1993 by Roger Sheldon

This file is part of the Lily C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef __GNUG__
#include <std.h>        // for strcmp
#else
#include <string.h>
#endif

#include "symbol.h"

// This file includes the Symbol and special_Symbol classes.

INLINE LObject::LObject(char *s) {            // declared in object.h
    value = new Symbol(s);
    value->Ref();
}

///////////////////////////////////////////////////////////////// Public Methods

INLINE Symbol::Symbol(char *s) {
#ifdef COUNTOBJS
    fprintf(tracefp,"count++ = %d, %d, Symbol(char*) %s\n", 
        ++count, (int)this, s);
#endif
    value = new char[strlen(s)+1];
    DETret(!value);
    strcpy(value, s);
}

INLINE Symbol::~Symbol() {
#ifdef COUNTOBJS
    fprintf(tracefp,"count-- = %d, %d, Symbol is %s\n", 
        --count, (int)this, value);
#endif
    delete value;
}

INLINE Base & Symbol::Atom() { return *t.value; }

INLINE Base & Symbol::Copy() { return *new Symbol(value); }

INLINE Base & Symbol::Equal(Base &a) { 
    return (a.Type() == type_Symbol && !strcmp(value,((Symbol*)&a)->value))
        ? *t.value : *nil.value;
}

INLINE ostream& Symbol::Print(ostream& s) { return s << value; }

INLINE char * Symbol::Symbol_name() { return value; }

INLINE LObject_type Symbol::Type() { return type_Symbol; }

INLINE Base & Symbol::Typep(LObject_type a) 
    { return (a == type_Symbol) ? *t.value : *nil.value; }

////////////////////////////////////////////////////////////////// static_Symbol

INLINE special_Symbol::special_Symbol(char *s) : Symbol(s) { }

// Don't waste time doing reference counting for static symbols

INLINE Base *special_Symbol::Ref()                          { return this; }
INLINE void special_Symbol::Deref()                         { }
