/* 
Copyright (C) 1993 by Roger Sheldon

This file is part of the Lily C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef Real_h
#define Real_h

#include "object.h"

// NOTE: The Real class has no real_value() method like the Integer
// class's integer_value() method.  The reason is that the integer_value()
// method is sort of a hack necessary since the LObject class defines
// an int() conversion operator which automatically converts any
// object (including Integers) to 1.  I think this is a good scheme because
// it makes it very elegant to do conditional statements.  The drawback
// is the need for the integer_value() method to get around it.
// (The above assumes you know that a conditional expression in C evaluates
// to an int.)
 
class Real : public Base {
    float value;
public:
    Real(float i);
    ~Real();
    void    Decr(Base &a)           { value -= a.Real_value(); }
    void    Incr(Base &a)           { value += a.Real_value(); }
    Base &  Numberp()               { return *t.value; }
    float   Real_value()            { return value; }
    ostream&Print(ostream&s=cout);
    Base &  Equal(Base &a);
    LObject_type Type();
    Base &  Typep(LObject_type);

// Non-Lisp utilities
    Base &  Copy();
};

/////////////////////////////////////////////////////////// conditional inlining

#ifndef NOINLINE
    #include "real.c"
#endif

#endif  // #ifndef Real_h
