/* 
Copyright (C) 1993 by Roger Sheldon

This file is part of the Lily C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "real.h"

//LObject::LObject(int i) { value = (i) ? ((i==1)?t.value:new Real(i)) : nil.value; }

INLINE LObject::LObject(float i) {    // declared in object.h
    value = new Real(i);
    value->Ref(); 
}

////////////////////////////////////////////////////////////////////////

INLINE Real::Real(float i) {
#ifdef COUNTOBJS
    fprintf(tracefp,
        "count++ = %d, %d, Real(int) %f\n", ++count, (int)this, i);
#endif
    value = i;
}

INLINE Real::~Real() {
#ifdef COUNTOBJS
    fprintf(tracefp,"count-- = %d, Real is %f\n", --count, value);
#endif
}



/* NO .............

INLINE void Real::Decr(Base &a) {
    if (a.Type() != type_Real)
        cerr << "ERROR: Real::Decr(Base &a) expected "
                << "argument to be of type Real\n";
    else
        value -= ((Real*)&a)->value;
}

INLINE void Real::Incr(Base &a) {
    if (a.Type() != type_Real)
        cerr << "ERROR: Real::Decr(Base &a) expected "
                << "argument to be of type Real\n";
    else
        value += ((Real*)&a)->value;
}

    ......... */



INLINE Base & Real::Equal(Base &a) {
    return (a.Type()==type_Real && value==((Real*)&a)->value)
        ? *t.value : *nil.value; }

INLINE ostream& Real::Print(ostream& s) { return s << value; }

//INLINE Base & Real::Print() { printf("%f", value); return *this; }

INLINE LObject_type Real::Type() { return type_Real; }

INLINE Base & Real::Typep(LObject_type a)
    { return (a==type_Real) ? *t.value : *nil.value; }

/////////////////////////////////////////////////////////////// Non-Lisp Methods

INLINE Base & Real::Copy() { return *new Real(value); }
