/* 
Copyright (C) 1993 by Roger Sheldon

This file is part of the Lily C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "object.h"

//////////////////////////////////////////////////////////////// for debugging

/*
INLINE void Base::pr_refs() { 
    printf("%d :: ", refs);
    Print();
    printf("\n");
    if (Typep(type_Cons)) {
        if (Car())
            Car().pr_refs();
        if (Cdr())
            Cdr().pr_refs();
    }
}   
*/

///////////////////////////////////////////////////////////////////////// or()

LObject  ORA;
LObject  ORSTOP;

INLINE void OR_RESET() { ORSTOP = nil; ORA = nil; }

INLINE LObject OR(LObject &a) { if (a) { ORSTOP=t; ORA=a; } return ORSTOP; }

///////////////////////////////////////////////////////////////////////// Base

//INLINE Base::Base() { refs = 0; }

//INLINE Base::~Base() { }

INLINE void Base::Deref() { if (--refs == 0) delete this; }

INLINE Base *Base::Ref() { refs++; return this; }

INLINE Base::operator int() { return 1; }

INLINE Base& Base::Assoc(Base &a) { DE; return *nil.value; }

/////////////////////////////////////////////////////////////////////// LObject

INLINE LObject::LObject() { value = nil.value; }

INLINE LObject::LObject(LObject &a) { value = a.value->Ref(); }

INLINE LObject::LObject(Base &v) { value = v.Ref(); }

INLINE void LObject::operator=(LObject &a) { 
    Base *save = value;
    value = a.value->Ref();
    save->Deref();
}

INLINE LObject::~LObject() { value->Deref(); }

INLINE ostream& operator << (ostream& s, LObject &a) { return a.value->Print(s); }

INLINE LObject::operator == (LObject &a) {
    if (typep(a, type_null))
        return value->Null_(); 
    else
        return value->Equal(*a.value);
}

INLINE LObject::operator != (LObject &a) { return !operator==(a); }

INLINE LObject::operator int() { return value->operator int(); }

//////////////////////////////////////////////////////////////// Math operations

INLINE LObject operator + (LObject &a, LObject &b) 
    { return a.value->Integer_value() + b.value->Integer_value(); }
INLINE LObject operator - (LObject &a, LObject &b) 
    { return a.value->Integer_value() - b.value->Integer_value(); }
INLINE LObject operator * (LObject &a, LObject &b) 
    { return a.value->Integer_value() * b.value->Integer_value(); }
INLINE LObject operator / (LObject &a, LObject &b) 
    { return a.value->Integer_value() / b.value->Integer_value(); }

INLINE void LObject::operator += (LObject &a) { value->Incr(*a.value); }
INLINE void LObject::operator -= (LObject &a) { value->Decr(*a.value); }
