/* 
Copyright (C) 1993 by Roger Sheldon

This file is part of the Lily C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "symbol.h"
#include "integer.h"
#include "cons.h"

// This file contains all the Lily functions which take multiple arguments.
// See Steele's "Common Lisp" for details on how the functions behave.

LObject Append(VAR_ARGS) {       // copy all but last arg
    Base *arg[] = { ARG_LIST2 };
    Base *first = nil.value;
    if (arg[1] == LastArg.value)
        return *arg[0];
    else
        first = &arg[0]->Copy_list();
    Base *a = first;
    for (int i=2; i<MAX_ARGS && arg[i]!=LastArg.value; i++) {
        DETexit(&a->Typep(type_Cons) == nil.value); // error if arg not a list
        if (a != nil.value)
            a = & a->Last().Rplacd(arg[i-1]->Copy_list());
    }
    if (a != nil.value) {
        a->Last().Rplacd(*arg[i-1]);
        return *first;
    }
    else
        return *arg[i-1];
}

LObject list(VAR_ARGS) {
    Base *arg[] = { ARG_LIST2 };
    Base *first = nil.value;
    if (arg[0] != LastArg.value)
        first = new Cons(*arg[0]);
    Base *a = first;
    for (int i=1; i<MAX_ARGS && arg[i]!=LastArg.value; i++)
        a = & a->Rplacd(*new Cons(*arg[i]));
    return *first;
}

LObject mapcar_lambda(LObject &func, LObject &l, VAR_ARGS) {
    Base *arg[] = {ARG_LIST2};  // optional lexically scoped variables
    Base *first;
    if (l.value != nil.value) {
        first = list(funcall(func, car(l), x0,x1,x2,x3)).value;
        Base *a = first;
        for (Base *b=&l.value->Cdr(); b!=nil.value; b=&b->Cdr())
            a = & a->Rplacd(
                *new Cons(*(func.value->Funcall(b->Car(), ARGSM1).value)));
    }
    return *first;
}

// nconc efficiency note: If nconc frequently receives many nil arguments,
// then it would be more efficient to replace
//      if (a)
//          a = rplacd(last(a), arg[i]);
// with
//      if (a && arg[i])
//          a = rplacd(last(a), arg[i]);

LObject nconc(VAR_ARGS) {
    Base *arg[] = { ARG_LIST2 };
    Base *first = nil.value;
    if (arg[0] != LastArg.value)
        first = arg[0];
    Base *a = first;
    for (int i=1; i<MAX_ARGS && arg[i]!=LastArg.value; i++) {
            // Only last arg can be non-Cons:
        DETexit(&a->Typep(type_Cons) == nil.value)
        if (a != nil.value) // If arg[i]==nil.value, rplacd doesn't change a.
            a = & a->Last().Rplacd(*arg[i]);
    }
    return *first;
}

LObject product(VAR_ARGS) {
    Base *arg[] = { ARG_LIST2 };
    int ans = 1;
    for (int i=0; i<MAX_ARGS && arg[i]!=LastArg.value; i++)
        ans *= arg[i]->Integer_value();
    return *new Integer(ans);
}

