/* 
Copyright (C) 1993 by Roger Sheldon

This file is part of the Lily C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "global.h"
#include "lily.h"

#ifdef __GNUG__
#include <stream.h>
#else
#include <fstream.h>
#endif

LObject myreverse(LObject &l)
{
	if (l == nil)
		return nil;
	else
		return Append(myreverse(cdr(l)),
									list(car(l)));
}

LObject echo(ifstream &s)
{
	LObject a;
	for (s >> a;  a != LilyEOF; s >> a)
		cout << a << '\n';
	return t;
}

// Lily Echo Program

int main() {

// Example to maintain a database of peoples' names and ages.

// Create an empty list

LObject persons = nil;

// Add a record to the list

persons = cons(list("Betsy", 34), persons);	// now persons == ((Betsy 34))

// Add another record to the list

persons = cons(list("Fred", 105), persons);	// now persons == ((Fred 105) (betsy 34))

// How old is Betsy?

LObject BetsysAge = cadr(assoc("Betsy", persons));

cout << persons << '\n' << BetsysAge << '\n';

exit(0);




	LObject x("xyz");
	car(x);
	exit(0);

//	cout << myreverse(list(1, list("foo", "bar"), nil, t, 3)) << "\n";


	ifstream s("in.");
	if (! s)
	{
		cout << "Could not open input file\n";
		return 0;
	}
	echo(s);
exit(0);

	LObject a;
	for (s >> a; a != LilyEOF ; s >> a)
			cout << a << "\n";
/*
		LObject a;
		for (cin >> a; a != LilyEOF ; cin >> a) {
				cout << a << "\n";
		}
*/
}
