/* 
Copyright (C) 1993 by Roger Sheldon

This file is part of the Lily C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "match.h"

LObject One("?"),
    Many("+"),
    Set(">"),
    Get("<"),
    Restrict("RESTRICT");

////////////////////////////////////////////// Initialize Restriction Predicates

    static LObject colors = list("red","white","blue");
    static LObject bad_words = list("shucks","darn");

    static LObject colorp(VAR_ARGS) 
        { LObject *arg[]={ARG_LIST}; return member(*arg[0], colors); }
    static LObject bad_wordp(VAR_ARGS) 
        { LObject *arg[]={ARG_LIST}; return member(*arg[0], bad_words); }
    static LObject func_colorp =         defun("colorp",     colorp);
    static LObject func_bad_wordp =  defun("bad_wordp",  bad_wordp);

///////////////////////////////////////////////////////// Pattern Variable Stuff

static LObject shove_gr(LObject &variable, LObject &item,LObject &alist) {
    return Append(alist, list(list(variable, item)));
}

static LObject pattern_indicator(LObject &l) { return car(l); }

LObject pattern_variable(LObject &l) { return cadr(l); }

static LObject pull_value(LObject &variable, LObject &alist) {
    return cadr(assoc(variable, alist));
}

static LObject shove_pl(LObject &variable, LObject &item, LObject &alist) {
    if (!alist)
        return list(list(variable, list(item)));
//  else if (variable == caar(alist))
    else if (equal(variable,caar(alist)))
        return cons(list(variable, Append(cadar(alist), list(item))),
                    cdr(alist));
    else
        return cons(car(alist), shove_pl(variable, item, cdr(alist))); 
}

/////////////////////////////////////////////////////////////////// Restrictions

static LObject restriction_indicator(LObject &pattern_item) {
    return cadr(pattern_item);
}

static LObject restriction_predicates(LObject &pattern_item) {
    return cddr(pattern_item);
}

static LObject test(LObject &predicates, LObject &argument) {
    if (!predicates)
        return t;
    else if (funcall(car(predicates), argument))
        return test(cdr(predicates), argument);
    else
        return nil;
}

////////////////////////////////////////////////////////////////////////// Match

LObject match(LObject &p, LObject &d, LObject &assgn) {
    LObject temp;
    if (!p && !d) {         // p and d both empty?
        if (!assgn)
            return t;
        else
            return assgn;
    }
    else if (!p || !d)
        return nil;
//  else if (car(p) == One || car(p) == car(d))
    else if (equal(car(p),One) || equal(car(p),car(d)))
        return match(cdr(p), cdr(d), assgn);
//  else if (car(p) == Many)            // First element '+'
    else if (equal(car(p),Many)) {      // First element '+'
#ifdef __TURBOC__   // can't handle destructors in ?: conditionals
        LObject temp = match(cdr(p), cdr(d), assgn);
        if (temp)
            return temp;
        else
            return match(p, cdr(d), assgn);
#else
        return or(match(cdr(p), cdr(d), assgn), match(p, cdr(d), assgn));
#endif
    }
    else if (atom(car(p)))
        return nil;
//  else if (pattern_indicator(car(p)) == Set)
    else if (equal(pattern_indicator(car(p)),Set))
        return match(cdr(p), cdr(d), 
            shove_gr(pattern_variable(car(p)), car(d), assgn));
//  else if (pattern_indicator(car(p)) == Get)
    else if (equal(pattern_indicator(car(p)),Get))
        return match(cons(pull_value(pattern_variable(car(p)), assgn),
                          cdr(p)), d, assgn);
//  else if (pattern_indicator(car(p)) == Many) {
    else if (equal(pattern_indicator(car(p)),Many)) {
        LObject new_assgn = shove_pl(pattern_variable(car(p)), car(d), assgn);
#ifdef __TURBOC__   // can't handle destructors in ?: conditionals
        LObject temp = match(cdr(p), cdr(d), new_assgn);
        if (temp)
            return temp;
        else
            return match(p, cdr(d), new_assgn);
#else
        return or(match(cdr(p), cdr(d), new_assgn), match(p,cdr(d),new_assgn));
#endif
    }
//  else if (pattern_indicator(car(p)) == Restrict &&
//           restriction_indicator(car(p)) == One &&
    else if (equal(pattern_indicator(car(p)),Restrict) &&
             equal(restriction_indicator(car(p)),One) &&
             test(restriction_predicates(car(p)), car(d)))
        return match(cdr(p), cdr(d), assgn);
    else        // matches implicit return of nil in a Lisp cond form
        return nil;
}
