/* 
Copyright (C) 1993 by Roger Sheldon

This file is part of the Lily C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef Integer_h
#define Integer_h

#include "object.h"

// This file includes the Integer class

class Integer : public Base {
    int value;
public:
    Integer(int i);
    ~Integer();
    void    Decr(Base &a)           { value -= a.Integer_value(); }
    void    Incr(Base &a)           { value += a.Integer_value(); }
    int     Integer_value();
    Base &  Numberp()               { return *t.value; }
    ostream&Print(ostream&s=cout);
    Base &  Equal(Base &a);
    LObject_type Type();
    Base &  Typep(LObject_type);
    operator int()                  { return value; }

// Non-Lisp utilities
    Base &  Copy();
};

/////////////////////////////////////////////////////////// conditional inlining

#ifndef NOINLINE
    #include "integer.c"
#endif

#endif  // #ifndef Integer_h
