/* 
Copyright (C) 1993 by Roger Sheldon

This file is part of the Lily C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "integer.h"

// This file includes the Integer class.

INLINE LObject::LObject(int i) {  // declared in object.h
    value = new Integer(i); 
    value->Ref(); 
}

////////////////////////////////////////////////////////////////////////

INLINE Integer::Integer(int i) {
#ifdef COUNTOBJS
    fprintf(tracefp,
        "count++ = %d, %d, Integer(int) %d\n", ++count, (int)this, i);
#endif
    value = i;
}

INLINE Integer::~Integer() {
#ifdef COUNTOBJS
    fprintf(tracefp,"count-- = %d, Integer is %d\n", --count, value);
#endif
}

INLINE int Integer::Integer_value() { return value; }

INLINE Base & Integer::Equal(Base &a) {
    return (a.Type()==type_Integer && value==a.Integer_value()) 
        ? *t.value : *nil.value; }

INLINE ostream& Integer::Print(ostream& s) { return s << value; }

INLINE LObject_type Integer::Type() { return type_Integer; }

INLINE Base & Integer::Typep(LObject_type a) 
    { return (a==type_Integer) ? *t.value : *nil.value; }

/////////////////////////////////////////////////////////////// Non-Lisp Methods

INLINE Base & Integer::Copy() { return *new Integer(value); }
