/* 
Copyright (C) 1993 by Roger Sheldon

This file is part of the Lily C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

// This file must be #included in the file containing
// the main() program *before* #including lily.h.  This is necessary
// because this file contains global objects which must be constructed first.

#ifndef global_h
#define global_h

#include "lily.h"

// Stuff from object.c:

FILE *tracefp = fopen("count.", "w");   // externed in object.h
//FILE *tracefp = stdout;

CharPtrFctPtrVHMap Function::FunctionMap(0);	// in function.h

int Base::count = 0;
int Null::count_calls = 0;

static Null _nil;
static special_Symbol _LastArg("LastArg"), _LilyEOF("LilyEOF"), _t("t");
LObject  nil     = _nil,
				LastArg = _LastArg,    // used in mult_arg.c
				LilyEOF = _LilyEOF,    // returned from yyparse() in case of EOF
				t       = _t;          // currently used only in match(p,d,a)


#else
@@@ error global.h was not the first file included in this module
#endif
