/* 
Copyright (C) 1993 by Roger Sheldon

This file is part of the Lily C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef Function_h
#define Function_h

#include "symbol.h"
#include "fctmapvh.h"

// NOTE: Symbol::Equal() is used which assumes that all Symbols have
// been converted to Functions immediately after being read from input.

class Function : public Symbol {
	static CharPtrFctPtrVHMap FunctionMap;	// defined in global.h so it
											// is constructed at correct time
    FctPtr fct;
    friend class init_Functions;
    friend LObject defun(char *, FctPtr);                 
    friend Base *assign_sym_or_func(char *);
public:
    Function(char *, FctPtr);
    ~Function();
                
    LObject      Funcall(VAR_ARGS);
    FctPtr     Symbol_Function();
    LObject_type Type();
    Base &      Typep(LObject_type);
};

//////////////////////////////////////////////////////////////////////////

LObject defun(char *, FctPtr);
void assign_if_Function(LObject &sym);

#endif  // #ifndef Function_h
