/* 
Copyright (C) 1993 by Roger Sheldon

This file is part of the Lily C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "function.h"

////////////////////////////////////////////////////////////// cons(de)structors

INLINE Function::Function(char *s, FctPtr f) : Symbol(s) {
#ifdef COUNTOBJS
    fprintf(tracefp,"count++ = %d, Function\n", ++count);
#endif
	fct = f;
}

INLINE Function::~Function() {
#ifdef COUNTOBJS
    fprintf(tracefp,"count-- = %d, Function\n", --count);
#endif
}

//////////////////////////////////////////////////////////////////////// Methods

INLINE LObject Function::Funcall(VAR_ARGS) { return fct(CALL_ARGS); }

INLINE FctPtr Function::Symbol_Function() { return fct; }

INLINE LObject_type Function::Type() { return type_Function; }

INLINE Base & Function::Typep(LObject_type a) 
    { return (a==type_Function) ? *t.value : *nil.value; }

///////////////////////////////////////////////////////// Function Binding Stuff

INLINE LObject defun(char *str, FctPtr func) { 
	if ( Function::FunctionMap.contains(str) )
		cout << "WARNING, function " << str << " already defun'ed\n";
	else
		Function::FunctionMap[str] = func;
    return *new Function(str, func);
}

// assign_sym_or_func is called from yyparse in read.c

INLINE Base *assign_sym_or_func(char *s) {
	if ( Function::FunctionMap.contains(s) )
		return new Function(s, Function::FunctionMap[s]);
	else
		return new Symbol(s);
}
