/* 
Copyright (C) 1993 by Roger Sheldon

This file is part of the Lily C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

// Lily friend functions -- these functions constitute the external interface
// to the Lily library.

// No #ifndef wrapper is needed in this file since it #included only by object.h

FRIEND LObject       Append          (VAR_ARGS);
// "Append" is used rather than "append" because "append" is defined in
// some system library.
FRIEND LObject       assoc           (LObject &a, LObject &b);
FRIEND LObject       atom            (LObject &a);
FRIEND LObject       car             (LObject &a);
FRIEND LObject       cdr             (LObject &a);
FRIEND LObject       cons            (LObject &a, LObject &b); // defined in cons.c
FRIEND LObject       copy            (LObject &a);
FRIEND LObject       copy_list       (LObject &a);
FRIEND LObject       copy_tree       (LObject &a);
FRIEND LObject       equal           (LObject &a, LObject &b);
FRIEND LObject       funcall         (LObject &func, VAR_ARGS);
FRIEND LObject       last            (LObject &a);
FRIEND LObject       length          (LObject &a);
FRIEND LObject       list            (VAR_ARGS);
FRIEND LObject       mapcar          (LilyFunction f, LObject &a);
FRIEND LObject       mapcar          (FctPtr f, LObject &);
FRIEND LObject       mapcar          (FctPtr f, LObject &, LObject &);
FRIEND LObject       mapcar_lambda   (LObject &func, LObject &l, VAR_ARGS);
FRIEND LObject       member          (LObject &a, LObject &b);
FRIEND LObject       nconc           (VAR_ARGS);
FRIEND LObject       nth             (LObject &n, LObject &a);
FRIEND LObject       null            (LObject &a);
FRIEND LObject       numberp         (LObject &a);
FRIEND int			 integer_value   (LObject &a);    
FRIEND ostream&      print           (LObject &a, ostream& s=cout);
FRIEND LObject       product         (VAR_ARGS);
FRIEND LObject       push            (LObject &a, LObject &b);
FRIEND LObject       read            ();             // defined in read.c
FRIEND LObject       read            (istream &);    // defined in read.c
FRIEND LObject       read_from_string(char *);       // defined in read.c
FRIEND float         real_value      (LObject &a);
FRIEND LObject       reverse         (LObject &a);    // reverses toplevel only
FRIEND LObject       reverse1        (LObject &a);    // reverses sublists too
FRIEND LObject       rplaca          (LObject &a, LObject &b);
FRIEND LObject       rplacd          (LObject &a, LObject &b);
FRIEND LObject       set_difference  (LObject &l1, LObject &l2);
FRIEND FctPtr       Symbol_Function (LObject &a);
	// CAUTION: Symbol_name() returns the symbol's internal name -- ie, don't
	// delete it.
FRIEND char *        Symbol_name     (LObject &a);
FRIEND LObject_type  type            (LObject &a);
FRIEND LObject       typep           (LObject &a, LObject_type b);

FRIEND LObject caar(LObject &a);
FRIEND LObject cadr(LObject &a);
FRIEND LObject cdar(LObject &a);
FRIEND LObject cddr(LObject &a);
FRIEND LObject cadar(LObject &a);
FRIEND LObject caddr(LObject &a);
FRIEND LObject cadddr(LObject &a);
FRIEND LObject caddddr(LObject &a);

FRIEND LObject first     (LObject &);
FRIEND LObject second    (LObject &);
FRIEND LObject third     (LObject &);
FRIEND LObject fourth    (LObject &);
FRIEND LObject fifth     (LObject &);
FRIEND LObject sixth     (LObject &);
FRIEND LObject seventh   (LObject &);
FRIEND LObject eighth    (LObject &);
FRIEND LObject ninth     (LObject &);
FRIEND LObject tenth     (LObject &);
