/* 
Copyright (C) 1993 by Roger Sheldon

This file is part of the Lily C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/
// Lily friend functions -- these functions constitute the external interface
// to the Lily library.
#include "object.h"

INLINE LObject assoc (LObject &a, LObject &b)  { return b.value->Assoc(*a.value); }
INLINE LObject atom  (LObject &a)             { return a.value->Atom(); }
INLINE LObject car   (LObject &a)             { return a.value->Car(); }
INLINE LObject cdr   (LObject &a)             { return a.value->Cdr(); }
INLINE LObject copy  (LObject &a)             { return a.value->Copy(); }
INLINE LObject copy_list(LObject &a)          { return a.value->Copy_list(); }
INLINE LObject copy_tree(LObject &a)          { return a.value->Copy_tree(); }
INLINE LObject equal (LObject &a, LObject &b)  { return a.value->Equal(*b.value); }
INLINE LObject funcall(LObject &f, VAR_ARGS)
	{ return f.value->Funcall(CALL_ARGS); }
INLINE int    integer_value(LObject &a)		{ return a.value->Integer_value(); }
INLINE LObject last  (LObject &a)             { return a.value->Last(); }
INLINE LObject length(LObject &a)             { return a.value->Length(); }
INLINE LObject nth(LObject &n, LObject &a)     { return a.value->Nth(*n.value); }
INLINE LObject null  (LObject &a)             { return a.value->Null_(); }
INLINE LObject numberp(LObject &a)            { return a.value->Numberp(); }
INLINE LObject mapcar(LilyFunction f, LObject &a) { return a.value->Mapcar(f); }
INLINE LObject mapcar(FctPtr f, LObject &a) { return a.value->Mapcar(f); }
INLINE LObject mapcar(FctPtr f, LObject &a1, LObject &a2)
	{ return a1.value->Mapcar(f, *a2.value); }
INLINE LObject member(LObject &a, LObject &b)  { return b.value->Member(*a.value);}
INLINE ostream&print(LObject &a, ostream& s) { return a.value->Print(s); }
INLINE LObject push  (LObject &a, LObject &b)  { return b.value->Push(*a.value); }
INLINE float  real_value(LObject &a)         { return a.value->Real_value(); }
INLINE LObject reverse(LObject &a)            { return a.value->Reverse(); }
INLINE LObject reverse1(LObject &a)           { return a.value->Reverse1(); }
INLINE LObject rplaca(LObject &a, LObject &b)  { return a.value->Rplaca(*b.value);}
INLINE LObject rplacd(LObject &a, LObject &b)  { return a.value->Rplacd(*b.value);}
INLINE LObject set_difference(LObject &l1, LObject &l2)
	{ return l1.value->Set_difference(*l2.value); }
INLINE FctPtr  Symbol_Function(INLINE LObject &a)
	{ return a.value->Symbol_Function(); }
INLINE char *   Symbol_name(INLINE LObject &a) { return a.value->Symbol_name(); }
INLINE LObject_type type(LObject &a)          { return a.value->Type(); }
INLINE LObject typep (LObject &a, LObject_type b)  { return a.value->Typep(b); }

INLINE LObject caar(LObject &a)       { return a.value->Car().Car(); }
INLINE LObject cadr(LObject &a)       { return a.value->Cdr().Car(); }
INLINE LObject cdar(LObject &a)       { return a.value->Car().Cdr(); }
INLINE LObject cddr(LObject &a)       { return a.value->Cdr().Cdr(); }
INLINE LObject cadar(LObject &a)      { return a.value->Car().Cdr().Car(); }
INLINE LObject caddr(LObject &a)      { return a.value->Cdr().Cdr().Car(); }
INLINE LObject cadddr(LObject &a)     { return a.value->Cdr().Cdr().Cdr().Car(); }
INLINE LObject caddddr(LObject &a)
	{ return a.value->Cdr().Cdr().Cdr().Cdr().Car(); }

INLINE LObject first     (LObject &a) { return 
a.value->Car(); }

INLINE LObject second    (LObject &a) { return 
a.value->Cdr().Car(); }

INLINE LObject third     (LObject &a) { return 
a.value->Cdr().Cdr().Car(); }

INLINE LObject fourth    (LObject &a)  { return
a.value->Cdr().Cdr().Cdr().Car(); }

INLINE LObject fifth     (LObject &a) { return
a.value->Cdr().Cdr().Cdr().Cdr().Car(); }

INLINE LObject sixth     (LObject &a) { return
a.value->Cdr().Cdr().Cdr().Cdr().Cdr().Car(); }

INLINE LObject seventh   (LObject &a) { return
a.value->Cdr().Cdr().Cdr().Cdr().Cdr().Cdr().Car(); }

INLINE LObject eighth    (LObject &a) { return
a.value->Cdr().Cdr().Cdr().Cdr().Cdr().Cdr().Cdr().Car(); }

INLINE LObject ninth     (LObject &a) { return
a.value->Cdr().Cdr().Cdr().Cdr().Cdr().Cdr().Cdr().Cdr().Car(); }

INLINE LObject tenth     (LObject &a) { return
a.value->Cdr().Cdr().Cdr().Cdr().Cdr().Cdr().Cdr().Cdr().Cdr().Car(); }
