// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _CharPtrFctPtrVHMap_h
#ifdef __GNUG__
#pragma interface
#endif
#define _CharPtrFctPtrVHMap_h 1

#include "fctmap.h"


class CharPtrFctPtrVHMap : public CharPtrFctPtrMap
{
protected:
  CharPtr*           tab;
  FctPtr*           cont;
  char*          status;
  unsigned int   size;

public:
                CharPtrFctPtrVHMap(FctPtr  dflt,unsigned int sz=DEFAULT_INITIAL_CAPACITY);
                CharPtrFctPtrVHMap(CharPtrFctPtrVHMap& a);
                ~CharPtrFctPtrVHMap();

  FctPtr&          operator [] (CharPtr  key);

  void          del(CharPtr  key);

  Pix           first();
  void          next(Pix& i);
  CharPtr&          key(Pix i);
  FctPtr&          contents(Pix i);

  Pix           seek(CharPtr  key);
  int           contains(CharPtr  key);

  void          clear(); 
  void          resize(unsigned int newsize = 0);

  int           OK();
};

inline CharPtrFctPtrVHMap::~CharPtrFctPtrVHMap()
{
  delete [] tab;
  delete [] cont;
  delete [] status;
}

inline int CharPtrFctPtrVHMap::contains(CharPtr  key)
{
  return seek(key) != 0;
}

inline CharPtr& CharPtrFctPtrVHMap::key(Pix i)
{
  if (i == 0) error("null Pix");
  return *((CharPtr*)i);
}

inline FctPtr& CharPtrFctPtrVHMap::contents(Pix i)
{
  if (i == 0) error("null Pix");
  return cont[((unsigned)(i) - (unsigned)(tab)) / sizeof(CharPtr)];
}

#endif
