/* 
Copyright (C) 1993 by Roger Sheldon

This file is part of the Lily C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "fchain.h"
#include "match.h"      // for pattern_variable()

static LObject Assertions;

static LObject remember(LObject &a) {     // remember an assertion
    if (member(a, Assertions))
        return nil;
    else {
        Assertions = cons(a, Assertions);
        return a;
    }
}

/////////////////////////////////////////////////////////////// Stream Utilities

static LObject combine_streams(LObject &s1, LObject &s2) { return Append(s1, s2); }

static LObject add_to_stream(LObject &e, LObject &s) { return cons(e, s); }

static LObject first_of_stream(LObject &s) { return car(s); }

static LObject rest_of_stream(LObject &s) { return cdr(s); }

static LObject empty_stream_p(LObject &s) { return !s; }

static LObject make_empty_stream() { return nil; }

///////////////////////////////////////////////////// Forward-Chaining Functions

static LObject filter_assertions(LObject &pattern, LObject &initial_alist) {
    LObject alist_stream = make_empty_stream();
    for (LObject a=Assertions; a; a=cdr(a)) {
        LObject new_alist = match(pattern, car(a), initial_alist);
        if (new_alist)
            alist_stream = add_to_stream(new_alist, alist_stream);
    }
    return alist_stream;
}

static LObject filter_alist_stream(LObject &pattern, LObject &alist_stream) {
    if (empty_stream_p(alist_stream))
        return make_empty_stream();
    else
        return combine_streams(
            filter_assertions(pattern, first_of_stream(alist_stream)),
            filter_alist_stream(pattern, rest_of_stream(alist_stream)));
}

static LObject cascade_thru_patterns(LObject &patterns, LObject &alist_stream) {
    if (!patterns)
        return alist_stream;
    else
        return filter_alist_stream(car(patterns),
                cascade_thru_patterns(cdr(patterns), alist_stream));
}

static LObject replace_variables(LObject &s, LObject &alist) {
    if (atom(s))
        return s;
//  else if (car(s) == Get)         //equal(car(s), Get))
    else if (equal(car(s), Get))
        return cadr(assoc(pattern_variable(s), alist));
    else
        return cons(replace_variables(car(s), alist),
                        replace_variables(cdr(s), alist));
}

static LObject spread_thru_actions(LObject &rule_name, LObject &actions, LObject &alist) {
    LObject action_stream = make_empty_stream();
    extern ostream s;
    for (LObject a=actions; a; a=cdr(a)) {
        LObject action = replace_variables(car(a), alist);
        if (remember(action)) {
            cout << "\nRule " << rule_name << " says " << action << '\n';
            action_stream = add_to_stream(action, action_stream);
        }
    }
    return action_stream;
}

static LObject feed_to_actions(LObject &rule_name, LObject &actions, LObject &alist_stream) {
    if (empty_stream_p(alist_stream))
        return make_empty_stream();
    else 
        return combine_streams(
            spread_thru_actions(rule_name, actions, 
                                first_of_stream(alist_stream)),
            feed_to_actions(rule_name, actions, rest_of_stream(alist_stream)));
}

static LObject use_rule(LObject &rule) {
    LObject rule_name = cadr(rule);
    LObject ifs = reverse(cdr(caddr(rule)));
    LObject thens = cdr(cadddr(rule));
    LObject alist_stream = cascade_thru_patterns(ifs,
                          add_to_stream(nil, make_empty_stream()));
    LObject action_stream = feed_to_actions(rule_name, thens, alist_stream);
    return !empty_stream_p(action_stream);
}
            
LObject forward_chain(LObject &assertions, LObject &rules) {
    Assertions = assertions;
    LObject progress_made;
    for ( LObject rs=rules; rs; rs=cdr(rs))
        if (use_rule(car(rs))) {
            rs = rules;
            progress_made = t;
        }
    return progress_made;
}
