
/* 
Copyright (C) 1993 by Roger Sheldon

This file is part of the Lily C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

// Debugging Macros print the file and line when an error occurs.

#include <iostream.h>

#include <stdlib.h>     // for exit()

#define DE cerr << "ERROR: " << __FILE__ << " line: " << __LINE__ << "\n"

#define DEexit { DE; exit(0); }

#define DET(test) if (test) DE

#define DETret(test) if (test) return

#define DETexit(test) if (test) { DE; exit(0); }

#define DEretLObject(obj) { DE; return obj; }
