/* 
Copyright (C) 1993 by Roger Sheldon

This file is part of the Lily C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef cons_h
#define cons_h

// This file includes the Null and Cons classes for representing Lisp lists.

#include "object.h"

class Null;

class Cons : public Base  {
protected:
    Base  *_car;
    Base  *_cdr;
public:
    Cons();
    Cons(Base &a);
    Cons(Base &a, Base &b);
    ~Cons();

    Base &  Assoc(Base &a);
    Base &  Atom();
    Base &  Car()               { return *_car; }
    Base &  Cdr()               { return *_cdr; }
    Base &  Cons_(Base &a);
    Base &  Copy();
    Base &  Copy_list();
    Base &  Copy_tree();
    void    Deref();
    Base &  Equal(Base &a);
    Base &  Last();
    Base &  Length();
    Base &  Mapcar(LilyFunction f);
    Base &  Mapcar(FctPtr f);
    Base &  Mapcar(FctPtr f, Base &a2);
    Base &  Member(Base &a);
    Base &  Nth(Base &n);
    ostream&    PPrint(ostream&, int level);
    ostream&    Print(ostream&s=cout);
    Base &  Push(Base &a);
    Base &  Reverse();
    Base &  Reverse1();
    Base &  Rplaca(Base &a);
    Base &  Rplacd(Base &a);
    Base &  Set_difference(Base &l2);
    LObject_type Type();
    Base &  Typep(LObject_type);
};

class Null : public Cons {
    static int count_calls;     // Enforces single-instantiation rule.
protected:
    void    Deref();
    Base *  Ref();
public:
    Null();
    ~Null();

    Base &  Atom();
    Base &  Car()               { return *nil.value; }
    Base &  Cdr()               { return *nil.value; }
    Base &  Copy();
    Base &  Copy_list();
    Base &  Copy_tree();
    Base &  Equal(Base &a);
    Base &  Mapcar(LilyFunction f);
    Base &  Mapcar(FctPtr f);
    Base &  Mapcar(FctPtr f, Base &a2);
    Base &  Null_();
    ostream&    Print(ostream &s=cout);
    Base &  Push(Base &a);
    Base &  Reverse();
    Base &  Reverse1();
    Base &  Rplaca(Base &a);
    Base &  Rplacd(Base &a);
    Base &  Setq(Base &a);
    LObject_type Type();
    Base &  Typep(LObject_type type);
    operator int()              { return 0; }
};

#endif  // #ifndef Cons_h 
