
/*
    Copyright (c) 1994 Jeff Weisberg

    see the file "License"
*/

#ifdef RCSID
static const char *const rcsid
= "@(#)$Id: jlisp.c,v 1.28 94/08/23 08:51:51 weisberg Exp Locker: weisberg $";
#endif

#include <jlisp.h>
#include <stdio.h>
#include <setjmp.h>
#include <string.h>

extern void gc_mark(Obj);

Obj internal_gc_protect = IC_NIL;

void mark0(), marksymbx(), markvect(), markcdr(), markport(), markctfrm();
void markweak();

int free0(), freecdr(), freejlerror(), freeport();

Obj eqcdr(), eqdbl(), eqcmplx(), eqstr(), eqvect(), eqbign();
Obj eqsym(), eqcdr(), eqsymbox(), eqport(), eqcons();
Obj eqweak();

int prnvect(), prnbign(), prncmplx(), prnport(), prnenvec();
int prnsym(), prncons(), prnsymbx(), prnflt(), prndbl();
int prnstr(), prnfunc(), prnmacr(), prnccode();

DEFVAR(".version", Vversion, ".version what version are we using",
       makstr_c("Jeff's Lisp Version " QUOTIFY(VERSION_MAJOR) "; April 1994"))
DEFVAR(".versno", Vversno, ".versno the version number",
       makstr_c( QUOTIFY(VERSION_MAJOR) ))

Obj_Vtbl jlisp_vtbl[] = {
	/* mark, free, print, equalp */

	{ 0,0,                prncons, eqcons 		},	/* cons */
	{ mark0,    free0,    prnflt, eqcdr	 	},	/* float */
	{ mark0,    freecdr,  prndbl,eqdbl	 	},	/* double */
	{ mark0,    freecdr,  prncmplx, 0	        },	/* complex */
	{ mark0,    freecdr,  prnstr, eqstr    		},	/* string */
	{ markvect, freecdr,  prnvect, eqvect	 	},	/* vector */
	{ mark0,    freecdr,  prnbign 	/* eqbign */ 	},	/* big num */
	{ mark0,    freecdr,  0	 		 	},	/* symbol */
	{ mark0, freejlerror, prnccode, eqcdr 		},	/* c code */
	{ marksymbx, freecdr, 0 		 	},	/* sym box */	
	{ mark0, freejlerror, 0 			},	/* a free cell */
	{ mark0, freejlerror, 0		       		},	/* box of cells */
	{ markport, freeport, prnport, eqport		},	/* io ports */
	{ markcdr,  free0,    prnfunc			},	/* function */
	{ markcdr,  free0,    prnmacr			},	/* macro */
	{ markctfrm, freecdr, 0, 0	       		},	/* catch frame */
	{ markweak, freecdr,  0, eqweak			},	/* weak */
	{ markvect, freecdr,  prnenvec, eqvect		},	/* env */
	{ mark0, free0, 0,0, },				     	/* user1 */
	{ mark0, free0, 0,0, },					/* user2 */	
	{ mark0, free0, 0,0, },					/* user3 */
	{ mark0, free0, 0,0, },					/* user4 */
	{ mark0, free0, 0,0, },					/* user5 */
	{ mark0, free0, 0,0, },					/* user6 */
	{ mark0, free0, 0,0, },					/* user7 */
	{ mark0, free0, 0,0, },					/* user8 */
	
	{0,0,0,0}
};

void mark0(Obj a){

}

void markcdr(Obj a){
	
	gc_mark( CDR(a) );
}

void marksymbx(Obj a){
	/* mark a sym box -- */
	/* both the value cell and props */

	gc_mark( CSYM_BOX(a)->value );
	gc_mark( CSYM_BOX(a)->props );
	gc_mark( CSYM_BOX(a)->next  );
	gc_mark( CSYM_BOX(a)->prev  );	/* *must* not go back if using shallow binding */
}

void markvect(Obj a){
	/* mark vector */
	int sz = CLENGTH( a );
	Obj *box = CVECTOR(a);
	int i;

	for(i=0; i< sz; i++){
		gc_mark( box[i] );
	}
}

int free0(Obj a){
	return 0;
}

int freecdr(Obj a){

	free( (void*) CDR(a) );
	return 1;
}

int freejlerror(Obj a){
	int p = CAR(a) >> 12;
	
	printf("Error: Free: ");
	Fdisplay(a, IC_UNSPEC);
	printf("\n");
	printf("(0x%x . 0x%x)\n", CAR(a), CDR(a));
	printf("\t{%x, %x, %x, %x }\n",
	       (p>>7)&1,
	       (p>>6)&31,
	       (p>>1)&31,
	       p &1);

/*	jlerror("free", a, "bad"); */
	return 0;
}

Obj maksym(char *sym){
	Obj foo;
	int sigs;

	foo = makstr(sym);
	DISABLE( sigs );
	CAR( foo ) = MAKETYPE( TPV_SYMBOL );
	RENABLE( sigs );
	
	return foo;
}

Obj maksym_c(char *sym){
	Obj foo;
	int sigs;

	foo = makstr_c(sym);
	DISABLE( sigs );
	CAR( foo ) = MAKETYPE( TPV_SYMBOL );
	RENABLE( sigs );
	
	return foo;
}

Obj makvect(int len){
	Obj foo = newcell(), bar;
	register int i;
	int sigs;

	bar = (Obj)(Obj*)my_malloc(sizeof(Obj)*len);
	DISABLE( sigs );
	CAR( foo ) = MAKETYPE( TPV_VECTOR ) | (len << 12);
	CDR( foo ) = bar;

	for(i=0; i<len; i++){
		CVECTOR(foo)[i] = IC_UNDEF;
	}
	RENABLE( sigs );
	return foo;
}

DEFUN("makevector", Fmakevector,Smakevector,1,1,1,0,
      "(makevector len) create a vector of specified length",
      (Obj a))
{
	register int len;

	if(INUMP(a)) len = CINT(a);
	else if( VECTORP(a) || STRINGP(a) ) len = CLENGTH(a);
	/* size from a list ? */
	else{
		return jlerror("makevector",a, "How big?");
	}
	return makvect(len);
}


Obj makfloat(float f){
	Obj foo = newcell();
	int sigs;

	DISABLE( sigs );
	CAR(foo) = MAKETYPE( TPV_FLOAT );
	CDR(foo) = *((Obj*)&f);
	RENABLE( sigs );
	return foo;
}
Obj makdbl(double d){
	Obj foo = newcell(), bar;
	int sigs;

	bar = (Obj)my_malloc(sizeof(double));
	DISABLE( sigs );
	CAR(foo) = MAKETYPE( TPV_DOUBLE );
	CDR(foo) = bar;
	*(double*)CDR(foo) = d;
	RENABLE( sigs );
	return foo;
}

Obj makbign(long l){
	Obj foo = newcell(), bar;
	int sigs;
	int sgn = l<0 ?-1:1;
	l = l<0 ? -l : l;

	bar = (Obj)my_malloc(sizeof(short)*2);
	DISABLE( sigs );
	CAR(foo) = MAKETYPE( TPV_BIGNUM ) | ((sgn*2)<<12);
	CDR(foo) = bar;
	RENABLE( sigs );
	
	CBIGNUM(foo)[0] = l & 0xFFFF;
	CBIGNUM(foo)[1] = l >> 16;

	return foo;
}

#if 0
Obj makcmplx(double r, double i){
	Obj foo = newcell(), bar;
	int sigs;

	bar = (Obj)my_malloc(sizeof(Complex));
	DISABLE( sigs );
	CAR(foo) = MAKETYPE( TPV_COMPLEX );
	CDR(foo) = bar;
	RENABLE( sigs );
	
	CCOMPLEX(foo).re = r;
	CCOMPLEX(foo).im = i;
	return foo;
}
#endif

DEFUN("makecomplex",Fmakecomplex,Smakecomplex,2,2,1,0,
      "(make-complex r i) return a complex number",
      (Obj r, Obj i))
{
	double rr, ii;
	
	if(INUMP(r)) rr = CINT(r);
	else if(FLOATP(r)) rr = CFLOAT(r);
	else if(DOUBLEP(r))rr = CDOUBLE(r);
	else rr = 0.0;

	if(INUMP(i)) ii = CINT(i);
	else if(FLOATP(i)) ii = CFLOAT(i);
	else if(DOUBLEP(i))ii = CDOUBLE(i);
	else ii = 0.0;

	return IC_NIL;
	/* return makcmplx(rr,ii); */ 
}

Obj makport( FILE* fp, int rw){
	Obj foo = newcell();
	int sigs;
	
	if( ! fp ) return IC_FALSE;
	DISABLE( sigs );
	CAR(foo) = MAKETYPE( TPV_IOPORT ) | (rw <<12);
	CDR(foo) = (Obj)fp;
	RENABLE( sigs );
	return foo;
}

Obj eqstr(Obj a, Obj b){
	int l = CLENGTH(a);

	if( l != CLENGTH(b)) return IC_FALSE;
	
	return strncmp(CCHARS(a), CCHARS(b), l) ? IC_FALSE : IC_TRUE;
}

Obj eqcdr(Obj a, Obj b){

	return CDR(a)==CDR(b) ? IC_TRUE : IC_FALSE;
}

#if 0
Obj eqcmplx(Obj a, Obj b){

	return 
		(CCOMPLEX(a).re == CCOMPLEX(b).re
		 && CCOMPLEX(a).im == CCOMPLEX(b).im) ?  IC_TRUE : IC_FALSE;
}
#endif

Obj eqdbl(Obj a, Obj b){

	return CDOUBLE(a) == CDOUBLE(b) ? IC_TRUE : IC_FALSE;
}

Obj eqvect(Obj a, Obj b){
	int l;

	if( CLENGTH(a) != (l=CLENGTH(b)) )
		return IC_FALSE;

	for(l--;l>=0; l--){
		if( CVECTOR(a)[l] != CVECTOR(a)[l])
			return IC_FALSE;
	}
	return IC_TRUE;
}

Obj eqcons(Obj a, Obj b){

	return ( Fequal(CAR(a), CAR(b)) && Fequal(CDR(a), CDR(b)) )
		? IC_TRUE : IC_FALSE;
}

