
/*
    Copyright (c) 1994 Jeff Weisberg

    see the file "License"
*/

#ifdef RCSID
static const char *const rcsid
= "@(#)$Id: init.c,v 1.24 94/08/23 10:49:42 weisberg Exp Locker: weisberg $";
#endif

#include <jlisp.h>
#include <stdio.h>

/* so we can use these without needed to look them up */
Obj stdin_port, stdout_port, stderr_port;
Obj sym_stdout, sym_stdin;
Obj sym_optional, sym_rest, sym_quote;
Obj sym_quote, sym_bquote, sym_bq_comma, sym_bq_comma_at;
Obj sym_iradix, sym_oradix;
Obj sym_docstring;
Obj sym_eof;
Obj sym_eval_function, sym_eval_macro;


Obj *stackbase;
void init_init(void), init_jlisp(int, char**);
EXTERN_C Obj Fread(Obj);
EXTERN_C Obj Fload(Obj);

extern void pushenv(void);
extern Obj envcurr, envlist, internal_gc_protect;
extern Obj lineno;
extern int initialized;
extern unsigned  etext, edata, end, Brk;

#undef DEFUN
#define DEFUN(ln, cn, sn, min, max, ep, lp, doc, pr)	\
	extern Defun_Decl sn;
#include <defun.list>
#undef DEFUN

#undef DEFVAR
#define DEFVAR(ln, cn, doc, val)			\
	extern Obj cn;
#include <defvar.list>		
#undef DEFVAR	

void init_csyms( Defun_Decl *decl ){
	
	Obj csym, cbox;
	Obj ccode = newcell();
	int sigs;
	
	DISABLE( sigs );
	CAR( ccode ) = MAKETYPE( TPV_C_CODE ) | SDBIT;
	CDR( ccode ) = (Obj)decl;
	RENABLE( sigs );
	
	csym = maksym_c( decl->name );
	Fdefine( csym, makstr_c(decl->doc), ccode);
}

#ifndef NOT_STAND_ALONE
int main(int argc, char**argv){
	
	init_jlisp(argc, argv);

	if(! initialized){
		fprintf(stderr, "Loading...");
		
		if(   (Fload(makstr_c( QUOTIFY( JLISP_INIT ) )) == IC_FALSE)
		   && (Fload(makstr_c("./lisp/init.jl" )) == IC_FALSE)
		   && (Fload(makstr_c("./init.jl" )) == IC_FALSE) ){
			fprintf(stderr, "jlisp aborting, could not load init file: \"%s\"\n",
				QUOTIFY( JLISP_INIT ));
			Fquit(MAKINT(-1));
		}
		fprintf(stderr, "Done.\n");
	}

	/* initialize signal handlers */
	Fcall(maksym_c("%initialize-signal-handlers%"));
	/* do command line args */
	Feval(getvalue(maksym_c("%parse-cmd-line%")));
	/* enter repl */
	Feval(getvalue(maksym_c("%repl%")));
	Fquit(MAKINT(0));

}
#endif

void init_jlisp(int argc, char**argv){
	Obj box;
	int i;
	
	stackbase = (Obj*) &argc;
	
	if( Brk) brk( Brk);	/* make sure break is right after dump */

	tzset();		/* in case it was cached */
	
	if( !initialized){
		pushenv();
		init_init();
	}

	/* inter the command line args */
        box = makvect( argc );
        for(i=0; i<argc; i++){
                CVECTOR(box)[i] = makstr( argv[i] );
        }
	Fdefine( maksym_c("*argv*"),
		box,
		makstr_c( "*argv* vector of command line arguments"));
	
}

void init_init(void){
	Obj box, foo;
	int i;
	
	sym_docstring = maksym_c(".docstring");
	Fdefine( sym_docstring, sym_docstring, IC_UNSPEC);
	
	/* setup stdio ports */
	stdin_port =  makport( stdin, READABLE);
	sym_stdin = maksym_c("*stdin_port*");
	Fdefine( sym_stdin,
		makstr_c("standard input port"),
		stdin_port);
	
	stdout_port = makport( stdout, WRITABLE);
	sym_stdout = maksym_c("*stdout_port*");
	Fdefine( sym_stdout,
		makstr_c("standard output port"),
		stdout_port);
	
	stderr_port = makport( stderr, WRITABLE);
	Fdefine( maksym_c("*stderr_port*"),
		makstr_c("standard jlerror port"),
		stderr_port);

	/* and some other useful symbols */
	sym_rest = maksym_c("&rest");
	Fdefine( sym_rest,
		makstr_c("&rest signal the rest of the arguments"),
		sym_rest);

	sym_optional = maksym_c("&optional");
	Fdefine( sym_optional,
		makstr_c("&optional signal optional arguments"),
		sym_optional);

	sym_iradix = maksym_c("%input-radix%");
	Fdefine( sym_iradix,
		MAKINT(10),
		makstr_c( "%input-radix% the radix used for numbers on input"));

	sym_oradix = maksym_c("%output-radix%");
	Fdefine( sym_oradix,
		MAKINT(10),
		makstr_c( "%output-radix% the radix used for numbers on output"));

#undef DEFUN
#define DEFUN(ln, cn, sn, min, max, ep, lp, doc, pr)	\
		init_csyms( &sn );
#include <defun.list>

#undef DEFVAR
#define DEFVAR(ln, cn, doc, val)			\
	foo = maksym_c(ln);				\
	Fdefine(foo, makstr_c(doc), IC_UNDEF);		\
	cn = Fenvlookup(foo, IC_UNSPEC);	    	\
	CAR( cn ) |= SDBIT;				\
	VALUE( cn ) = val;
	
#include <defvar.list>		
		

	sym_eof = maksym_c("eof");
	sym_eval_function = Fenvlookup(maksym_c("#<:internal:eval-function>"), IC_UNSPEC);
	sym_eval_macro = Fenvlookup(maksym_c("#<:internal:eval-macro>"), IC_UNSPEC);
	sym_quote = Fenvlookup( maksym_c("quote"), IC_UNSPEC);
	sym_bquote = Fenvlookup( maksym_c("backquote"), IC_UNSPEC);
	sym_bq_comma = Fenvlookup( maksym_c("unquote"), IC_UNSPEC);
	sym_bq_comma_at = Fenvlookup( maksym_c("unquote-splice"), IC_UNSPEC);

	PROTECT_SYM( sym_iradix );
	PROTECT_SYM( sym_oradix );
	PROTECT_SYM( sym_eof );
	PROTECT_SYM( sym_stdout );
	PROTECT_SYM( sym_stdin );

}

	
	
	

	
	
