
/*
    Copyright (c) 1994 Jeff Weisberg

    see the file "License"
*/

#ifdef RCSID
static const char *const rcsid
= "@(#)$Id: eval.c,v 1.22 94/08/23 10:49:24 weisberg Exp Locker: weisberg $";
#endif

#include <jlisp.h>

extern void pushenv(void), popenv(void);
extern Obj sym_rest, sym_optional;
extern Obj sym_eval_function, sym_eval_macro;
extern Obj sym_eof;
extern Obj getvalue(Obj);
extern Obj debugger(Obj, Obj);

Backtrace *backtrace_list=0;

Obj eval_internal(Obj, int, char*);

DEFVAR(".debug-on-next-call", Vdebug_on_next_call,
       ".debug-on-next-call if not #f the debugger will be entered prior to the next call",
       IC_FALSE)
     

DEFUN("eval", Feval, Seval, 1,1, 1,0 ,
      "(eval form) evaluate form",
      (Obj argl))
{
	return eval_internal(argl, 1, Seval.name);
}

DEFUN("funcall", Ffuncall, Sfuncall, 1,1,1,1,
      "(funcall func args...) call func with args",
      (Obj argl))
{
	return eval_internal(argl, 0, Sfuncall.name);
}

DEFUN("apply", Fapply, Sapply, 1,1,1,1,
      "(apply func args... arglist) apply func to args arglist",
      (Obj l))
{
	Obj head=l, tail=IC_NIL;
	Obj fnc = CAR(l);
	l = CDR(l);

	if( NULLP(l) || NULLP( CDR(l))){
		/* (f) || (f l) */

		if( NNULLP(CAR(l)) && NCONSP( CAR(l)))
			return jlerror(Sapply.name, CAR(l), "WTA: listp");

		return Ffuncall(Fcons(fnc, CAR(l)));
	}

	/* (f a.. l) */
	while( CONSP( CDDR(l))){
		l = CDR(l);
	}
	/* join */
	CDR(l) = CADR(l);

	return eval_internal( head, 0, Sapply.name);

}
	


Obj eval_internal(Obj arg, int eval_args, char* fncname){
	Obj foo, qux, quux, retval;
	int nmin, nmax, listp, evalp;
	long bar;
	register int i;
	int n, typ = TYPEOFX( arg );
	Backtrace bt;
	int being_stepped = 0;
	int flag =0;
	
	struct Cargs {
		Obj r[32];
	} cargs;

	bzero( &cargs, sizeof(cargs));	/* to keep GC happy */
	
	switch( typ ){

	  case TPV_FREE_CELL:
	  case TPV_BOX_CELLS:
		return jlerror(fncname, arg, "Cannot evaluate form");

	  case TPV_SYM_BOX:
		return getvalue( arg );
		/* or just return CSYM_BOX( arg )->value; */
		
	  case TPV_SYMBOL:
		foo = Fenvlookup( arg, IC_UNSPEC );	/* lookup in default current env */
		if( ! SYMBOXP( foo ) ){
			return jlerror(fncname, arg, "Undefined symbol");
		}
		return getvalue( foo );		

	  case TPVF_CONS:
		arg = Fcopylist(arg);
		/* set up backtrace frame and find fnc defn */
		foo = eval_internal( bt.fncname=CAR(arg), 1, fncname);
		bt.fncdefn = foo;
		bt.argl    = CDR( arg );
		bt.dbg_me  = 0;
		bt.next    = backtrace_list;

		switch( TYPEOFX( foo ) ){

		  case TPV_FUNCTION:
			/* make it look like:
			(#<:internal:eval-function>  function  args)
			*/
		  case TPV_MACRO:
			/* make it look like:
			(#<:internal:eval-macro>  macro  args)
			*/
			
			if( CDBGME(foo))
				VALUE( Vdebug_on_next_call ) = IC_TRUE;

			CAR(arg) = foo;
			if( TYPEOFX(foo)==TPV_FUNCTION)
				foo = sym_eval_function;
			else
				foo = sym_eval_macro;
			foo = getvalue( foo ); 
			arg = Fcons(foo, arg);
			/* fall thru' */
			
		  case TPV_C_CODE:
			/* call c code */
			
			if( VALUE( Vdebug_on_next_call )!=IC_FALSE){
				/* enter debugger on call? */
				if( VALUE( Vdebug_on_next_call )==IC_TRUE)
					being_stepped = 1;
				VALUE( Vdebug_on_next_call ) = IC_FALSE;
				bt.dbg_me = 1;
				backtrace_list = &bt;
				debugger( MAKINT(0), IC_NIL );
				/* we keep the btl clean in case we get an error... */
				backtrace_list = bt.next;
			}
			
			/* 1st figure out how... */
			evalp = CCDECL(foo)->evalp;
			listp = CCDECL(foo)->listp;
			nmin  = CCDECL(foo)->minarg;
			nmax  = CCDECL(foo)->maxarg;
			n = 0;
			
			if( !evalp && !eval_args)
				return jlerror(fncname, foo, "Incorrect type of function");
			if(! eval_args)
				evalp = 0;
			
			if( evalp ){
				/* traverse args and eval them -- but not more than nmax */
				qux = CDR(arg);
				if(flag) Fdisplay(arg, IC_UNSPEC);
				
				while( NNULLP( qux )){
					if(flag) Fdisplay(CAR(qux), IC_UNSPEC);
					if( being_stepped && VALUE(Vdebug_on_next_call)==IC_FALSE)
						VALUE( Vdebug_on_next_call ) = IC_NIL;
					if( listp || n < nmax)
						CAR(qux) = Feval( CAR(qux));
					if(flag) Fdisplay(CAR(qux), IC_UNSPEC);
					qux = CDR(qux);
					n++;
				}
				qux = CDR(arg);
				if(flag) Fdisplay(arg, IC_UNSPEC);
				if(flag) Fdisplay(MAKCHAR('\n'), IC_UNSPEC);
				
			}else{
				qux = quux = CDR( arg );

				/* and count them */
				while( NNULLP( quux ) ){
					n++;
					quux = CDR( quux );
				}
			}
			
			if( !listp && (n < nmin || n > nmax) ){
				return jlerror(fncname, foo, "Wrong number of parameters");

			}

			/* setup backtrace frame */
			backtrace_list = &bt;
			
			if( listp ){
				/* call with list */
				retval = ((Obj(*)(Obj))CCFUNC( foo ))(qux);
				goto done;
			}
			
			/* set up args */
			i = 0;
			while( i < n ){
				cargs.r[i++] = CAR( qux );
				qux = CDR( qux );
			}
			for(; i<32; i++)
				cargs.r[i] = IC_UNSPEC;
			switch( nmax ){
			  case 0:
				retval = ((Obj(*)(...))CCFUNC( foo ))();
				goto done;
			  case 1:
				retval = ((Obj(*)(...))CCFUNC( foo ))(
					cargs.r[0]
				);
				goto done;
			  case 2:
				retval = ((Obj(*)(...))CCFUNC( foo ))(
					cargs.r[0],
					cargs.r[1]
				);
				goto done;
			  case 3:
				retval = ((Obj(*)(...))CCFUNC( foo ))(
					cargs.r[0],
					cargs.r[1],
					cargs.r[2]
				);
				goto done;
			  case 4:
				retval = ((Obj(*)(...))CCFUNC( foo ))(
					cargs.r[0],
					cargs.r[1],
					cargs.r[2],
					cargs.r[3]
				);
				goto done;
			  case 5:
				retval = ((Obj(*)(...))CCFUNC( foo ))(
					cargs.r[0],
					cargs.r[1],
					cargs.r[2],
					cargs.r[3],
					cargs.r[4]
				);
				goto done;
			  case 6:
				retval = ((Obj(*)(...))CCFUNC( foo ))(
					cargs.r[0],
					cargs.r[1],
					cargs.r[2],
					cargs.r[3],
					cargs.r[4],
					cargs.r[5]
				);
				goto done;
			  case 7:
				retval = ((Obj(*)(...))CCFUNC( foo ))(
					cargs.r[0],
					cargs.r[1],
					cargs.r[2],
					cargs.r[3],
					cargs.r[4],
					cargs.r[5],
					cargs.r[6]
				);
				goto done;
			  case 8:
				retval = ((Obj(*)(...))CCFUNC( foo ))(
					cargs.r[0],
					cargs.r[1],
					cargs.r[2],
					cargs.r[3],
					cargs.r[4],
					cargs.r[5],
					cargs.r[6],
					cargs.r[7]
				);
				goto done;
			  case 9:
				retval = ((Obj(*)(...))CCFUNC( foo ))(
					cargs.r[0],
					cargs.r[1],
					cargs.r[2],
					cargs.r[3],
					cargs.r[4],
					cargs.r[5],
					cargs.r[6],
					cargs.r[7],
					cargs.r[8]
				);
				goto done;
			  case 10:
				retval = ((Obj(*)(...))CCFUNC( foo ))(
					cargs.r[0],
					cargs.r[1],
					cargs.r[2],
					cargs.r[3],
					cargs.r[4],
					cargs.r[5],
					cargs.r[6],
					cargs.r[7],
					cargs.r[8],
					cargs.r[9]
				);
				goto done;
			  case 12:
				retval = ((Obj(*)(...))CCFUNC( foo ))(
					cargs.r[0],
					cargs.r[1],
					cargs.r[2],
					cargs.r[3],
					cargs.r[4],
					cargs.r[5],
					cargs.r[6],
					cargs.r[7],
					cargs.r[8],
					cargs.r[9],
					cargs.r[10],
					cargs.r[11]
				);
				goto done;

			  default:
				retval = jlerror(fncname, MAKINT( nmax ),
					"internal error--nargs switch too small\n"
					"send in bug report");
					
				goto done;
			}
			
			break;
		  default:
			/* what ought be done about such cases
			   (non-fnc as a fnc call: (xxx ...))
			   ideas (RSN):
			       symbol	lookup again (as emacs does)
			       vector	bytecoded fnc?
			       numbers
			       strings
			       iconsts
			   (even if only for nif value)
			*/
			   
			return jlerror(fncname, foo, "not a function");
		}
		break;

	  default:
		if( arg == IC_EOF ){
			Fthrow(sym_eof, IC_TRUE);
		}
		/* all other types self evaluate */
		return arg;
	}
	return jlerror(fncname, IC_NIL, "internal error?");

  done:
	/* restore backtrace frame */
	if( bt.dbg_me ){
		VALUE( Vdebug_on_next_call ) = IC_FALSE;
		retval = debugger(MAKINT(1), retval);
	}
	backtrace_list = bt.next;
	return retval;
}

DEFUN("#<:internal:eval-function>", Feval_function, Seval_function, 1,1,1,1,
      "internal",
      (Obj a))
{
	
	Obj function = CAR(a), args = CDR(a);
	Obj params = CADR(function), body = CDDR(function);
	Obj result;
	Obj box, sy;
	int opt=0;
	
	pushenv();

	if(SYMBOLP(params)){
		box = Finter(params, IC_UNSPEC);
		CSYM_BOX(box)->value = args;
	}else{
		while( NNULLP(params) ){
			/* inter params into env with proper values */
			sy = CAR(params);
			if( sy==sym_optional ){
				opt = 1;
				params = CDR(params);
				continue;
			}
			if( sy==sym_rest ){
				sy = CADR(params);
				box = Finter(sy, IC_UNSPEC);
				CSYM_BOX(box)->value = args;
				params = args = IC_NIL;
			}

			if( NULLP(args)) break;
			box = Finter(sy, IC_UNSPEC);
			CSYM_BOX(box)->value = CAR(args);

			params = CDR(params);
			args = CDR(args);
		}
		if( opt && NNULLP(params)){
			/* inter the remaining optionals as unspec'd */
			while( NNULLP(params)){
				sy = CAR(params);
				if( sy==sym_rest ){
					     /* no more args for rest */
					params = CDR(params);
					sy = CAR(params);
				}
				
				box = Finter(sy, IC_UNSPEC);
				CSYM_BOX(box)->value = IC_UNSPEC;
				params = CDR(params);
			}
		}
		
		if( NNULLP(params) || NNULLP(args) ){
			return jlerror("eval-function", CDR(a), "Wrong number of parameters");
		}
	}

	result = Fprogn( body );
	popenv();
	return result;
}

DEFUN("expand-macro", Fexp_macr, Sexp_macr, 1,1,0,1,
      "(expand-macro macro args...) Expand a macro",
      (Obj m))
{
	CAR(m) = Feval( CAR(m)); /* lookup macro */
	if(! MACROP( CAR(m) ))
		return m;
	return Feval_function(m);
}

DEFUN("#<:internal:eval-macro>", Feval_macro, Seval_macro, 1,1, 0,1,
      "internal",
      (Obj a))
{
	
	return Feval( Feval_function( a ));
}








