
;;;; Copyright (c) 1994 Jeff Weisberg
;;;; see the file "License"

;;;; $Id: roman.jl,v 1.4 94/08/22 15:37:24 weisberg Exp Locker: weisberg $

(defun roman (num)
  "(roman number) return the roman numeral represenation of the number"
  (let ((rc #("/M"    "/D"   "/C"   "/L"  "/X"  "/V" ?M   ?D  ?C  ?L ?X ?V ?I))
	(rv #(1000000 500000 100000 50000 10000 5000 1000 500 100 50 10  5  1  0 0))
	(index 0)
	(str (strcpy "")))

    (while (nzerop num)
      (cond
       ((>= num (nth rv index))
	(strappend! str (nth rc index))
	(set! num (- num (nth rv index))))
       ((<= num (nth rv (+ index 1)))
	(set! index (+ index 1)))
       ((and (zerop (& index 1))
	     (>= num (- (nth rv index) (nth rv (+ index 2)))))
	(strappend! str (nth rc (+ index 2)))
	(strappend! str (nth rc index))
	(set! num (+ (- num (nth rv index))
		     (nth rv (+ index 2)))))
       ((and (nzerop (& index 1))
	     (>= num (- (nth rv index) (nth rv (+ index 1)))))
	(strappend! str (nth rc (+ index 1)))
	(strappend! str (nth rc index))
	(set! num (+ (- num (nth rv index))
		     (nth rv (+ index 1)))))
       (#t
	(set! index (+ index 1)))))
    str))





