
;;;; Copyright (c) 1994 Jeff Weisberg
;;;; see the file "License"

;;;; $Id: mrirc.cf.jl,v 1.7 94/08/11 15:50:49 weisberg Exp Locker: weisberg $
;;;; system wide config file for mritool program

; define-with name default-value type-predicate preprocess-command docstrings
(define-with mri:across 2 intp () "number of buttons across")
(define-with mri:buttons                                        ; the button labels
  '("R Temporal"        "L Temporal"
    "R White"           "L White"
    "R Grey"            "L Grey"
    "R Amygdala"        "L Amygdala"
    "R Hippocampus"     "L Hippocampus"
    "R Parahippocampus" "L Parahippocampus"
    "R Horn"            "L Horn"
    "R Brain"           "L Brain")
  listp () "a list of labels for the buttons")

(define-with mri:top-row
  '(
    ("File"     (("Patients"      "(show-patient-popup)")
		 ("Next Image"    "(set image next)")
		 ("Prev Image"    "(set image prev)")
		 ("Select Image"  "(show-image-popup)")))

    ("Command"  (("View Modes"    ( ("Image"       "(set mode view)")
				    ("Segm"        "(set mode segm)")))
		 ("Function"      ( ("Show LUT"    "(show-lut)")
				    ("New Frame"   "(new-frame)")
				    ("Analyze"     "(analyze)")))
		 ("Help"          "(help)")
		 ("Refresh"       "(refresh)")
		 ("Visine"        "(progn (visine)(refresh))")
		 ("Snake"         "(progn (show-snake-popup) (show-measure-popup) (show-bounds-popup))")
		 ("Segment"       "(progn (show-segm-popup)  (show-bounds-popup))")
		 ("Quit"          "(quit)")))
    
    )
  listp () "a list describing the buttons and menus along the top of the tool")


;;;    locate some important files
(define-with mri:patdir    (mriname "%PATDIR%")                         stringp mriname "where the mri-scans are")
(define-with mri:segmdir   (mriname "%SEGMDIR%")                        stringp mriname "where the segm data is kept")
(define-with mri:etcdir    (mriname "%ETCDIR%")                         stringp mriname "where some goodies are")
(define-with mri:savedir   (mriname "~/data/save")                      stringp mriname "where to save stuff")
(define-with mri:savename  "Datafile"                                   stringp ()      "the name of the data file")
(define-with mri:statefile ".mri-state"                                 stringp ()      "the name of the state file")
(define-with mri:helpfile  (strcat mri:etcdir "/help.txt")              stringp mriname "the help file")
(define-with mri:patients  ""                                           stringp mriname "list of patients for this project")

;;; various parameters
(define-with mri:line-width   2   intp () "the width of lines you draw")
(define-with mri:line-style   1   intp () "1=solid, 2=dashed, 3=double-dashed")
(define-with mri:erasor       16  intp () "size of erasor")

(define-with mri:elastic      20  intp () "default snake elasticity")
(define-with mri:attractive   15  intp () "default snake atractiveness")
(define-with mri:stiffness    100 intp () "default snake stiffness")
(define-with mri:3dconstraint 0   intp () "default snake 3D term")
(define-with mri:similarity   5   intp () "default snake similararity")
(define-with mri:maxiter      100 intp () "max # of iters when minimizing snake")
(define-with mri:percent      90  intp () "max # of iters when minimizing snake")

(define-with mri:nlev         6   intp () "defualt number of segm levels")

(define-with mri:window       230 intp () "default window")
(define-with mri:level        -15 intp () "default level")

(sets! prompt (lambda () (print-stderr "mri(" .lineno ") > ")))

(define-with mri:init-msg
  (lambda ()
    (display mri:version) (newline)
    (display .version)    (newline)
    (copyright)           (newline) (newline))
  procedurep () "thunk to display initialization message")

