/*
    mapfun.c -- Mapping.
*/
/*
    Copyright (c) 1993, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#include "config.h"

Lmapcar(int narg, object fun, ...)
{
	va_list lists;
	object *x, res, *val = &res;
	object cars[narg-1];	/* __GNUC__ */
	int i;

	if (narg < 2)
		FEtoo_few_arguments(&narg);
	res = Cnil;
	narg--;
	while (TRUE) {
	  va_start(lists, fun);
	  for (i = 0;  i < narg;  i++) {
#ifndef NO_ARG_ARRAY
	    x = (object *)lists;
	    va_arg(lists, object);
	    if (endp(*x)) {
	      VALUES(0) = res;
	      RETURN(1);
	    }
	    cars[i] = CAR(*x);
	    *x = CDR(*x);
#else
	    Rewrite this!
#endif NO_ARG_ARRAY
	  }
	  apply(narg, fun, cars);
	  val = &CDR(*val = CONS(VALUES(0), Cnil));
	}
}

Lmaplist(int narg, object fun, ...)
{
	va_list lists;
	object *x, res, *val = &res;
	object cars[narg-1];	/* __GNUC__ */
	int i;

	if (narg < 2)
		FEtoo_few_arguments(&narg);
	res = Cnil;
	narg--;
	while (TRUE) {
	  va_start(lists, fun);
	  for (i = 0;  i < narg;  i++) {
#ifndef NO_ARG_ARRAY
	    x = (object *)lists;
	    va_arg(lists, object);
	    if (endp(*x)) {
	      VALUES(0) = res;
	      RETURN(1);
	    }
	    cars[i] = *x;
	    *x = CDR(*x);
#else
	    Rewrite this!
#endif NO_ARG_ARRAY
	  }
	  apply(narg, fun, cars);
	  val = &CDR(*val = CONS(VALUES(0), Cnil));
	}
}

Lmapc(int narg, object fun, ...)
{
	va_list lists;
	object *x, res;
	object cars[narg-1];	/* __GNUC__ */
	int i;

	if (narg < 2)
		FEtoo_few_arguments(&narg);
	va_start(lists, fun);
	res = va_arg(lists, object);
	narg--;
	while (TRUE) {
	  va_start(lists, fun);
	  for (i = 0;  i < narg;  i++) {
#ifndef NO_ARG_ARRAY
	    x = (object *)lists;
	    va_arg(lists, object);
	    if (endp(*x)) {
	      VALUES(0) = res;
	      RETURN(1);
	    }
	    cars[i] = CAR(*x);
	    *x = CDR(*x);
#else
	    Rewrite this!
#endif NO_ARG_ARRAY
	  }
	  apply(narg, fun, cars);
	}
}

Lmapl(int narg, object fun, ...)
{
	va_list lists;
	object *x, res;
	object cars[narg-1];	/* __GNUC__ */
	int i;

	if (narg < 2)
		FEtoo_few_arguments(&narg);
	va_start(lists, fun);
	res = va_arg(lists, object);
	narg--;
	while (TRUE) {
	  va_start(lists, fun);
	  for (i = 0;  i < narg;  i++) {
#ifndef NO_ARG_ARRAY
	    x = (object *)lists;
	    va_arg(lists, object);
	    if (endp(*x)) {
	      VALUES(0) = res;
	      RETURN(1);
	    }
	    cars[i] = *x;
	    *x = CDR(*x);
#else
	    Rewrite this!
#endif NO_ARG_ARRAY
	  }
	  apply(narg, fun, cars);
	}
}

Lmapcan(int narg, object fun, ...)
{
	va_list lists;
	object *x, res, *val = &res;
	object cars[narg-1];	/* __GNUC__ */
	int i;

	if (narg < 2)
		FEtoo_few_arguments(&narg);
	res = Cnil;
	narg--;
	while (TRUE) {
	  va_start(lists, fun);
	  for (i = 0;  i < narg;  i++) {
#ifndef NO_ARG_ARRAY
	    x = (object *)lists;
	    va_arg(lists, object);
	    if (endp(*x)) {
	      VALUES(0) = res;
	      RETURN(1);
	    }
	    cars[i] = CAR(*x);
	    *x = CDR(*x);
#else
	    Rewrite this!
#endif NO_ARG_ARRAY
	  }
	  apply(narg, fun, cars);
	  *val = VALUES(0);
	  while (!endp(*val))
	    val = &CDR(*val);
	}
}

Lmapcon(int narg, object fun, ...)
{
	va_list lists;
	object *x, res, *val = &res;
	object cars[narg-1];	/* __GNUC__ */
	int i;

	if (narg < 2)
		FEtoo_few_arguments(&narg);
	res = Cnil;
	narg--;
	while (TRUE) {
	  va_start(lists, fun);
	  for (i = 0;  i < narg;  i++) {
#ifndef NO_ARG_ARRAY
	    x = (object *)lists;
	    va_arg(lists, object);
	    if (endp(*x)) {
	      VALUES(0) = res;
	      RETURN(1);
	    }
	    cars[i] = *x;
	    *x = CDR(*x);
#else
	    Rewrite this!
#endif NO_ARG_ARRAY
	  }
	  apply(narg, fun, cars);
	  *val = VALUES(0);
	  while (!endp(*val))
	    val = &CDR(*val);
	}
}

init_mapfun()
{
	make_function("MAPCAR", Lmapcar);
	make_function("MAPLIST", Lmaplist);
	make_function("MAPC", Lmapc);
	make_function("MAPL", Lmapl);
	make_function("MAPCAN", Lmapcan);
	make_function("MAPCON", Lmapcon);
}
