/*
    lwp.h  -- Light weight processes.
*/
/*
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/
#include <sys/ioctl.h>

typedef struct lpd {

  /* bds.h - The bind stack */
  struct bds_bd lwp_bind_stack[BDSSIZE + BDSGETA + BDSGETA];
  bds_ptr lwp_bds_limit;
  bds_ptr lwp_bds_top;

  /* eval.h - The C stack */

  int lwp_cssize;		/* see reset_stack_limits */
  int *lwp_cs_org;
  int *lwp_cs_limit;

  /* frame.h */
    /*The Invocation History stack */
  struct invocation_history lwp_ihs_stack[IHSSIZE + IHSGETA + IHSGETA];
  ihs_ptr lwp_ihs_limit;
  ihs_ptr lwp_ihs_top;

    /* The Frame stack */
  struct frame lwp_frame_stack[FRSSIZE + FRSGETA + FRSGETA];
  frame_ptr lwp_frs_limit;
  frame_ptr lwp_frs_top;

    /* Non-local jumps */
  frame_ptr lwp_nlj_fr;
  object lwp_nlj_tag;

  /* lex.h - Lexical environment */
  object *lwp_lex_env;

  /* vs.h - The value stack */
  object lwp_Values[VSSIZE];
  int *lwp_cs_limit;

  /* used in alloc.c */
  object lwp_alloc_temporary;

  /* backq.c */
  int lwp_backq_level;		/* It should be initialized with 0 (zero) */

  /* eval.c */
  int lwp_eval1;                /* It should be initialized with 0 (zero) */

  /* format.c */
  int (*lwp_fmt_ch_fun)();
  object lwp_fmt_stream;
  int lwp_ctl_origin;
  int lwp_ctl_index;
  int lwp_ctl_end;
  object *lwp_fmt_base;
  int lwp_fmt_index;
  int lwp_fmt_end;
  int *lwp_fmt_jmp_buf;
  int lwp_fmt_indents;
  object lwp_fmt_string;
  object lwp_fmt_temporary_stream;
  object lwp_fmt_temporary_string;
  int lwp_fmt_nparam;
  struct {
    int fmt_param_type;
    int fmt_param_value;
  } lwp_fmt_param[100];
  int lwp_fmt_spare_spaces;
  int lwp_fmt_line_length;

  /* lwp.c */
  object lwp_thread;

  /* list.d */
  object lwp_test_function;
  object lwp_item_compared;
  bool (*lwp_tf)();
  object lwp_key_function;
  object (*lwp_kf)();

  /* package.d */
  int lwp_intern_flag;

  /* print.d */
  jmp_buf lwp_CIRCLEjmp;
  object *lwp_CIRCLEbase;
  object *lwp_CIRCLEtop;
  object *lwp_CIRCLElimit;
  object lwp_PRINTstream;
  bool lwp_PRINTescape;
  bool lwp_PRINTpretty;
  bool lwp_PRINTcircle;
  int lwp_PRINTbase;
  bool lwp_PRINTradix;
  object lwp_PRINTcase;
  bool lwp_PRINTgensym;
  int lwp_PRINTlevel;
  int lwp_PRINTlength;
  bool lwp_PRINTarray;
/* LWP 2
 */
  bool lwp_PRINTpackage;
  bool lwp_PRINTstructure;

  int (*lwp_write_ch_fun)();
  int (*lwp_output_ch_fun)();
  short lwp_queue[Q_SIZE];
  short lwp_indent_stack[IS_SIZE];
  int lwp_qh;
  int lwp_qt;
  int lwp_qc;
  int lwp_isp;
  int lwp_iisp;

  /* read.d */
  object lwp_READtable;
  int lwp_READdefault_float_format;
  int lwp_READbase;
  bool lwp_READsuppress;
  bool lwp_preserving_whitespace_flag;
  bool lwp_escape_flag;
  object lwp_delimiting_char;
  bool lwp_detect_eos_flag;
  bool lwp_in_list_flag;
  bool lwp_dot_flag;
  object lwp_default_dispatch_macro;
  object lwp_big_register_0;
  int lwp_sharp_eq_context_max;
  object (*lwp_read_ch_fun)();

  /* symbol.d */
  object lwp_string_register;
  object lwp_gensym_prefix;
  object lwp_gentemp_prefix;
  object lwp_token;		/* They have to be initialized with
			         * alloc_simple_string and */
} lpd;


#define RUNNING		0
#define SUSPENDED	1
#define STOPPED		2
#define DEAD		3
#define WAITING		4


typedef struct pd {
  object pd_thread;             /* point back to its thread	 */
  int	 pd_status;		/* RUNNING or STOPPED or DEAD */
  int	 *pd_base;		/* Stack Base */
#ifdef VAX
  int	 pd_env[16];		/* Stack Environment */ 
#else
  sigjmp_buf  pd_env ;		/* Stack Environment */ 
#endif VAX
  int	 pd_slice;              /* time out			 */
  FILE	 *pd_fp;		/* File pointer waiting input on */
  lpd	 *pd_lpd;               /* lisp process descriptor */
  struct pd *pd_next;

} pd;



#define PUSH(lpd)     { if ( running_head == NULL)               \
			  { running_head = lpd;                  \
			   running_tail = lpd;                   \
			   lpd->pd_next = NULL;   }              \
		         else { lpd->pd_next = running_head;     \
			    running_head = lpd; } }

#define ENQUEUE(lpd)  { if  ( running_head == NULL )              \
			   {  running_head = lpd;                 \
			      running_tail = lpd ;                \
			      running_tail->pd_next = NULL; }      \
			 else {  running_tail->pd_next = lpd;     \
			         lpd->pd_next = NULL;             \
			         running_tail = lpd;  } }


#define ROTQUEUE()	 { running_tail->pd_next = running_head; \
			    running_head = running_head->pd_next; \
			    running_tail = running_tail->pd_next; \
			    running_tail->pd_next = NULL; }


/*
#define PUSH(lpd)     ( running_head == NULL \
			 ? (running_head = running_tail = lpd, \
			    lpd->pd_next = NULL) \
		         : (lpd->pd_next = running_head, \
			    running_head = lpd ) )

#define ENQUEUE(lpd) ( running_head == NULL \
			 ? (running_head = running_tail = lpd, \
			    running_tail->pd_next = NULL) \
			 : (running_tail->pd_next = lpd, \
			    lpd->pd_next = NULL, \
			    running_tail = lpd) )


#define DEQUEUE(lpd)    ( lpd = running_head, \
			   running_head != NULL \
			   ? running_head = lpd->pd_next \
			   : NULL )

#define ROTQUEUE()	( running_head != NULL \
			 ? (running_tail->pd_next = running_head, \
			    running_head = running_head->pd_next, \
			    running_tail = running_tail->pd_next, \
			    running_tail->pd_next = NULL ) \
			 : NULL )

*/

#define FOREVER 1

#define SPAWNSTART 0
#define SPAWNEND 1
#define SCHEDULE 2
#define REMOVELWP 3

#define TICK 20000		/* Microseconds */
#define QUANTUM 20000		/*      ""	*/
#define REALQUANTUM 100000	/*      ""      */

#define STACK_SIZE (CSSIZE+CSGETA)	/* Words */
