/*
    unixsys.s  -- Unix shell interface.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/

#include "config.h"

#if !defined(__stdlib_h) && !defined(_STDLIB_H_) && !defined(__STDLIB_H__) &&  !defined(_STDLIB_H)
#include <signal.h>
int
system(const char *command)
{
	char buf[4];
	extern sigint();

	signal(SIGINT, SIG_IGN);
	write(4, command, strlen(command)+1);
	read(5, buf, 1);
	signal(SIGINT, sigint);
	return(buf[0]<<8);
}
#endif __STDLIB_H__

Lsystem(int narg, object cmd)
{
	char command[1024];
	int i;

	check_arg(1);
	check_type_string(&cmd);
	if (cmd->st.st_fillp >= 1024)
		FEerror("Too long command line: ~S.", 1, cmd);
	for (i = 0;  i < cmd->st.st_fillp;  i++)
		command[i] = cmd->st.st_self[i];
	command[i] = '\0';
	VALUES(0) = MAKE_FIXNUM(system(command) >> 8);
	RETURN(1);
}

init_unixsys()
{
	make_function("SYSTEM", Lsystem);
}
